package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.innerpochta.beans.ByTimestampResp;
import ru.yandex.autotests.innerpochta.beans.yplatform.Envelope;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.List;
import java.util.stream.Stream;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.10.13
 * Time: 16:45
 */
@OperClass(
        description = "Запрос к yplatform. Выборка писем пользователя c вложениями",
        apicommand = "",
        apipath = "/messages_with_attaches"
)
public class MessagesWithAttaches extends Oper<MessagesWithAttaches> {
    public ByTimestampResp resp() {
        return fromJson(ByTimestampResp.class);
    }

    public static MessagesWithAttaches messagesWithAttaches(Obj params) {
        return api(MessagesWithAttaches.class).setHost(props().houndUri()).params(params);
    }

    Stream<Envelope> stream() {
        JsonParser parser = new JsonParser();
        JsonElement envelopes = parser.parse(respAsString).getAsJsonObject().get("envelopes");
        List<Envelope> envelope = new Gson().fromJson(envelopes, new TypeToken<List<Envelope>>(){}.getType());

        return envelope.stream();
    }

    public boolean hasMessage(String mid) {
        return stream()
                .anyMatch(e -> e.getMid().equals(mid));
    }

    public boolean hasMessageInFolder(String mid, String fid) {
        return stream()
                .filter(e -> e.getFid().equals(fid))
                .anyMatch(e -> e.getMid().equals(mid));
    }
}
