package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import java.util.List;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 11.11.15
 * Time: 14:56
 *
 * https://wiki.yandex-team.ru/users/jkennedy/ywmiapi/#nearestmessages
 */
@OperClass(
        description = "Запрос к yplatform. Возвращает prev/next письма относительно переданного ids.",
        apicommand = "",
        apipath = "/nearest_messages"
)
public class NearestMessages extends Oper<NearestMessages> {

    public static NearestMessages nearestMessages(Obj params) {
        return api(NearestMessages.class).setHost(props().houndUri()).params(params);
    }

    private int countMessagesInFolder() {
        return getMids().size();
    }

    public NearestMessages countShouldBe(int count) {
        assertThat("Неверное количество писем в выдаче nearest_messages",
                countMessagesInFolder(), equalTo(count));
        return this;
    }

    public NearestMessages code(Matcher<Integer> matcher) {
        assertThat("Неверное значение поля <code>", getIntFromJson("error.code"), matcher);
        return this;
    }

    public NearestMessages message(Matcher<String> matcher) {
        assertThat("Неверное значение поля <message>", getStringFromJson("error.message"), matcher);
        return this;
    }

    public NearestMessages reason(Matcher<String> matcher) {
        assertThat("Неверное значение поля <reason>", getStringFromJson("error.reason"), matcher);
        return this;
    }

    public List<String> getMids() {
        return JsonPath.read(respAsString, "$.envelopes.[*].mid");
    }
}
