package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;
import ru.yandex.autotests.innerpochta.wmicommon.WmiConsts;

import static com.jayway.restassured.path.json.JsonPath.from;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.09.15
 * Time: 19:10
 */
@OperClass(
        apicommand = "",
        description = "Запрос к yplatform. Сбрасывает флаг recent у папки",
        apipath = "/reset_unvisited"
)

public class ResetUnvisited extends Oper<ResetUnvisited> {

    public static ResetUnvisited resetUnvisitedFlag(Obj params) {
        return api(ResetUnvisited.class).setHost(props().houndUri()).params(params);
    }

    public ResetUnvisited ok() {
        assertThat(respAsString, equalTo("{}"));
        return this;
    }
    public Integer code() {
        return JsonPath.read(respAsString, "$.error.code");
    }

    public String message() {
        return JsonPath.read(respAsString, "$.error.message");
    }

    public String reason() {
        return JsonPath.read(respAsString, "$.error.reason");
    }

    public ResetUnvisited codeShouldBe(WmiConsts.WmiErrorCodes expected) {
        assertThat("Ожидали другое значение аттрибута <code>", code(), equalTo(expected.code()));
        return this;
    }

    public ResetUnvisited messageShouldBe(Matcher<String> matcher) {
        assertThat("Ожидали другое значение аттрибута <message>", message(), matcher);
        return this;
    }

    public ResetUnvisited reasonShouldBe(Matcher<String> matcher) {
        assertThat("Ожидали другое значение аттрибута <reason>", reason(), matcher);
        return this;
    }
}
