package ru.yandex.autotests.innerpochta.wmi.core.oper.hound;

import com.jayway.jsonpath.JsonPath;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.Obj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 03.08.15
 * Time: 15:17
 */
@OperClass(
        apicommand = "",
        description = "Запрос к yplatform. Получаем статус DB юзера",
        apipath = "/yamail_status"
)
public class YamailStatus extends Oper<YamailStatus> {

    public static YamailStatus yamailStatus(Obj params) {
        return api(YamailStatus.class).setHost(props().houndUri()).params(params);
    }

    /**
     * Достаем значение статуса БД
     *
     * @return узел со значением
     */
    public String getDbStatus() {
        return JsonPath.read(respAsString, "$.database_info.state");
    }

    public YamailStatus shouldBeDbStatus(String status) {
        assertThat("Неверное значение <state> ", getDbStatus(), is(status));
        return this;
    }


}
