package ru.yandex.autotests.innerpochta.wmi.core.oper.mops;

import com.google.common.base.Joiner;
import com.jayway.restassured.response.Response;
import lombok.val;
import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.wmi.core.mops.complexmove.ApiComplexMove;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.create.ApiFoldersCreate;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.createhiddentrash.ApiFoldersCreateHiddenTrash;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.delete.ApiFoldersDelete;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.update.ApiFoldersUpdate;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.updatepop3.ApiFoldersUpdatePop3;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.updateposition.ApiFoldersUpdatePosition;
import ru.yandex.autotests.innerpochta.wmi.core.mops.folders.updatesymbol.ApiFoldersUpdateSymbol;
import ru.yandex.autotests.innerpochta.wmi.core.mops.label.ApiLabel;
import ru.yandex.autotests.innerpochta.wmi.core.mops.labels.create.ApiLabelsCreate;
import ru.yandex.autotests.innerpochta.wmi.core.mops.labels.delete.ApiLabelsDelete;
import ru.yandex.autotests.innerpochta.wmi.core.mops.labels.update.ApiLabelsUpdate;
import ru.yandex.autotests.innerpochta.wmi.core.mops.mark.ApiMark;
import ru.yandex.autotests.innerpochta.wmi.core.mops.mark.ApiMark.StatusParam;
import ru.yandex.autotests.innerpochta.wmi.core.mops.ping.ApiPing;
import ru.yandex.autotests.innerpochta.wmi.core.mops.purge.ApiPurge;
import ru.yandex.autotests.innerpochta.wmi.core.mops.purgehiddentrash.ApiPurgeHiddenTrash;
import ru.yandex.autotests.innerpochta.wmi.core.mops.remove.ApiRemove;
import ru.yandex.autotests.innerpochta.wmi.core.mops.replylater.create.ApiReplyLaterCreate;
import ru.yandex.autotests.innerpochta.wmi.core.mops.replylater.remove.ApiReplyLaterRemove;
import ru.yandex.autotests.innerpochta.wmi.core.mops.replylater.reset.ApiReplyLaterReset;
import ru.yandex.autotests.innerpochta.wmi.core.mops.replylater.update.ApiReplyLaterUpdate;
import ru.yandex.autotests.innerpochta.wmi.core.mops.spam.ApiSpam;
import ru.yandex.autotests.innerpochta.wmi.core.mops.stat.ApiStat;
import ru.yandex.autotests.innerpochta.wmi.core.mops.unlabel.ApiUnlabel;
import ru.yandex.autotests.innerpochta.wmi.core.mops.unspam.ApiUnspam;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.source.Source;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.plugins.testpers.html.common.Code;

import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.api.MopsApi.apiMops;
import static ru.yandex.autotests.innerpochta.wmi.core.mops.MopsResponses.okFid;
import static ru.yandex.autotests.innerpochta.wmi.core.mops.MopsResponses.okLid;

public class Mops {
    public static void debugPrint(Response response) {
        System.out.println(Code.format(response.asString()));
    }

    public static ApiComplexMove complexMove(HttpClientManagerRule user, String destFid, Source source) throws Exception {
        val api = apiMops(user.account().userTicket()).complexMove()
                .withUid(user.account().uid())
                .withDestFid(destFid);
        source.fill(api);
        return api;
    }

    public static ApiComplexMove complexMove(HttpClientManagerRule user, String destFid, String destTab, Source source) throws Exception {
        val api = apiMops(user.account().userTicket()).complexMove()
                .withUid(user.account().uid())
                .withDestFid(destFid)
                .withDestTab(destTab);
        source.fill(api);
        return api;
    }

    public static ApiFoldersCreate createFolder(HttpClientManagerRule user, String name) {
        return apiMops(user.account().userTicket()).folders().create()
                .withUid(user.account().uid())
                .withName(name);
    }

    public static String newFolder(HttpClientManagerRule user, String name) {
        return createFolder(user, name).post(shouldBe(okFid())).then().extract().body().path("fid");
    }

    public static String newFolder(HttpClientManagerRule user, String name, String parentFid) {
        return createFolder(user, name).withParentFid(parentFid).post(shouldBe(okFid()))
                .then().extract().body().path("fid");
    }

    public static String newFolder(HttpClientManagerRule user, String name, Symbol symbol) {
        return createFolder(user, name).withSymbol(symbol.toString()).post(shouldBe(okFid()))
                .then().extract().body().path("fid");
    }

    public static ApiFoldersDelete deleteFolder(HttpClientManagerRule user, String fid) {
        return apiMops(user.account().userTicket()).folders().delete()
                .withUid(user.account().uid())
                .withFid(fid);
    }

    public static ApiFoldersUpdate updateFolder(HttpClientManagerRule user, String fid) {
        return apiMops(user.account().userTicket()).folders().update()
                .withUid(user.account().uid())
                .withFid(fid);
    }

    public static ApiFoldersUpdate renameFolder(HttpClientManagerRule user, String fid, String name) {
        return updateFolder(user, fid).withName(name);
    }

    public static ApiFoldersUpdatePop3 updatePop3(HttpClientManagerRule user, String... fids) {
        return apiMops(user.account().userTicket()).folders().updatePop3()
                .withUid(user.account().uid())
                .withFids(Joiner.on(",").join(fids));
    }

    public static ApiFoldersUpdatePosition updateFolderPosition(HttpClientManagerRule user, String fid) {
        return apiMops(user.account().userTicket()).folders().updatePosition()
                .withUid(user.account().uid())
                .withFid(fid);
    }

    public static ApiFoldersUpdateSymbol updateFolderSymbol(HttpClientManagerRule user, String fid) {
        return apiMops(user.account().userTicket()).folders().updateSymbol()
                .withUid(user.account().uid())
                .withFid(fid);
    }

    public static ApiLabelsCreate createLabel(HttpClientManagerRule user) {
        return apiMops(user.account().userTicket()).labels().create()
                .withUid(user.account().uid());
    }

    public static String newLabelBySymbol(HttpClientManagerRule user, String symbol) {
        return createLabel(user).withSymbol(symbol).post(shouldBe(okLid()))
                .then().extract().body().path("lid");
    }

    public static String newLabelByName(HttpClientManagerRule user, String name) {
        return createLabel(user).withName(name).post(shouldBe(okLid()))
                .then().extract().body().path("lid");
    }

    public static String newLabelByName(HttpClientManagerRule user, String name, String color) {
        return createLabel(user).withName(name).withColor(color).post(shouldBe(okLid()))
                .then().extract().body().path("lid");
    }

    public static ApiLabelsDelete deleteLabel(HttpClientManagerRule user, String lid) {
        return apiMops(user.account().userTicket()).labels().delete()

                .withUid(user.account().uid())
                .withLid(lid);
    }

    public static ApiLabelsUpdate updateLabel(HttpClientManagerRule user, String lid) {
        return apiMops(user.account().userTicket()).labels().update()
                .withUid(user.account().uid())
                .withLid(lid);
    }

    public static ApiLabelsUpdate changeLabelColor(HttpClientManagerRule user, String lid, String color) {
        return updateLabel(user, lid).withColor(color);
    }

    public static ApiLabel label(HttpClientManagerRule user, Source source, List<String> lids) throws Exception {
        val api = apiMops(user.account().userTicket()).label()
                .withUid(user.account().uid())
                .withLids(Joiner.on(",").join(lids));
        source.fill(api);
        return api;
    }

    public static ApiUnlabel unlabel(HttpClientManagerRule user, Source source, List<String> lids) throws Exception {
        val api = apiMops(user.account().userTicket()).unlabel()
                .withUid(user.account().uid())
                .withLids(Joiner.on(",").join(lids));
        source.fill(api);
        return api;
    }

    public static ApiMark mark(HttpClientManagerRule user, Source source, StatusParam status) throws Exception {
        val api = apiMops(user.account().userTicket()).mark()
                .withUid(user.account().uid())
                .withStatus(status);
        source.fill(api);
        return api;
    }

    public static ApiPurge purge(HttpClientManagerRule user, Source source) throws Exception {
        val api = apiMops(user.account().userTicket()).purge()
                .withUid(user.account().uid());
        source.fill(api);
        return api;
    }

    public static ApiRemove remove(HttpClientManagerRule user, Source source) throws Exception {
        val api = apiMops(user.account().userTicket()).remove()
                .withUid(user.account().uid());
        source.fill(api);
        return api;
    }

    public static ApiSpam spam(HttpClientManagerRule user, Source source) throws Exception {
        val api = apiMops(user.account().userTicket()).spam()
                .withUid(user.account().uid());
        source.fill(api);
        return api;
    }

    public static ApiUnspam unspam(HttpClientManagerRule user, Source source) throws Exception {
        val api = apiMops(user.account().userTicket()).unspam()
                .withUid(user.account().uid());
        source.fill(api);
        return api;
    }

    public static ApiStat stat(HttpClientManagerRule user) {
        return apiMops(user.account().userTicket())
                .stat()
                .withUid(user.account().uid());
    }

    public static ApiStat stat(HttpClientManagerRule user, String uid) {
        return apiMops(user.account().userTicket())
                .stat()
                .withUid(uid);
    }

    public static ApiPing ping() {
        return apiMops("").ping();
    }

    public static ApiFoldersCreateHiddenTrash createHiddenTrash(HttpClientManagerRule user) {
        return apiMops(user.account().userTicket())
               .folders().createHiddenTrash()
               .withUid(user.account().uid());
    }

    public static ApiPurgeHiddenTrash purgeHiddenTrash(HttpClientManagerRule user) {
        return apiMops(user.account().userTicket())
                .purgeHiddenTrash()
                .withUid(user.account().uid());
    }

    public static ApiReplyLaterCreate createReplyLaterSticker(HttpClientManagerRule user, String mid, Long date) {
        return apiMops(user.account().userTicket())
                .replyLater().create()
                .withUid(user.account().uid())
                .withMid(mid)
                .withDate(date.toString());
    }

    public static ApiReplyLaterRemove removeReplyLaterSticker(HttpClientManagerRule user, String mid) {
        return apiMops(user.account().userTicket())
                .replyLater().remove()
                .withUid(user.account().uid())
                .withMid(mid);
    }

    public static ApiReplyLaterUpdate updateReplyLaterSticker(HttpClientManagerRule user, String mid, Long date) {
        return apiMops(user.account().userTicket())
                .replyLater().update()
                .withUid(user.account().uid())
                .withMid(mid)
                .withDate(date.toString());
    }

    public static ApiReplyLaterReset resetReplyLaterSticker(HttpClientManagerRule user, String mid, Long date) {
        return apiMops(user.account().userTicket())
                .replyLater().reset()
                .withUid(user.account().uid())
                .withMid(mid)
                .withDate(date.toString());
    }
}
