package ru.yandex.autotests.innerpochta.wmi.core.oper.mops.source;

import com.google.common.base.Joiner;
import lombok.val;
import java.util.List;

public class TabSource implements Source {
    private final String tab;

    public TabSource(String tab) {
        this.tab = tab;
    }

    @Override
    public <T> void fill(T obj) throws Exception {
        val method = obj.getClass().getMethod("withTab", String.class);
        method.invoke(obj, tab);
    }
}