package ru.yandex.autotests.innerpochta.wmi.core.oper.newapi;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.empty;
import static org.hamcrest.Matchers.not;

@OperClass(
        description = "Новое api. Выдаем саджест из абука",
        apicommand = "",
        apipath = "/api/v2/abook_suggest"
)
public class AbookSuggest extends Oper<AbookSuggest> {

    public AbookSuggest uid(Matcher<String> matcher) {
        assertThat("Неверное значение у аттрибута <uid> ", JsonPath.read(respAsString, "$.[0].uid"), matcher);
        return this;
    }

    public AbookSuggest hasEmails() {
        assertThat("Ожидали непустой массив адресов", JsonPath.read(respAsString, "$.[0].contacts.[*]"), not(empty()));
        return this;
    }
}
