package ru.yandex.autotests.innerpochta.wmi.core.oper.newapi;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.empty;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 26.06.15
 * Time: 17:35
 */
@OperClass(
        description = "Новое api. Выдаем аккаунты для мультикуки",
        apicommand = "",
        apipath = "/api/v2/accounts"
)
public class Accounts extends Oper<Accounts> {

    public String uid() {
        return JsonPath.read(respAsString, "$.uid");
    }

    public Accounts uid(Matcher<String> matcher) {
        assertThat("Неверное значение у аттрибута <uid> ", uid(), matcher);
        return this;
    }

    public Accounts emptyMulti() {
        assertThat("Ожидали пустой массив в <multi>", JsonPath.read(respAsString, "$.multi"), empty());
        return this;
    }
}
