package ru.yandex.autotests.innerpochta.wmi.core.oper.newapi;

import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.beans.mobile.api.v2.Counters;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.nullValue;
import static ru.yandex.autotests.innerpochta.beans.mobile.api.v2.CountersMatchers.withError;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 19.11.14
 * Time: 15:50
 */
@OperClass(
        description = "Новое api. Выдаем значения счётчиков",
        apicommand = "",
        apipath = "/api/v2/counters"
)
public class CountersCommand extends Oper<CountersCommand> {

    public static CountersCommand counters() {
        return api(CountersCommand.class);
    }

    public Integer fresh() {
        return bean().getCounters().getFresh().intValue();
    }

    public Integer unread() {
        return bean().getCounters().getUnread().intValue();
    }

    public CountersCommand freshShouldBe(Matcher<Integer> matcher) {
        assertThat("Неверное значение у аттрибута <fresh> ", fresh(), matcher);
        return this;
    }

    public CountersCommand unreadShouldBe(Matcher<Integer> matcher) {
        assertThat("Неверное значение у аттрибута <unread> ", unread(), matcher);
        return this;
    }

    public Counters bean() {
        return fromJson(Counters.class);
    }

    public CountersCommand shouldNotSeeError() {
        assertThat(bean(), withError(nullValue(ru.yandex.autotests.innerpochta.beans.mobile.api.v2.Error.class)));
        return this;
    }
}
