package ru.yandex.autotests.innerpochta.wmi.core.oper.newapi;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import ru.yandex.autotests.innerpochta.beans.yplatform.Lid;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.util.Map;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

@OperClass(
        description = "Новое api. Выдаем список меток",
        apicommand = "",
        apipath = "/api/v2/labels"
)
public class LabelsCommand extends Oper<LabelsCommand> {
    public static LabelsCommand labels() {
        return api(LabelsCommand.class);
    }

    public Map<String, Lid> resp() {
        JsonParser parser = new JsonParser();
        JsonElement lidsFragment = parser.parse(respAsString).getAsJsonObject().get("labels");

        return new Gson().fromJson(lidsFragment, new TypeToken<Map<String, Lid>>(){}.getType());
    }
}
