package ru.yandex.autotests.innerpochta.wmi.core.oper.newapi;

import com.jayway.jsonpath.JsonPath;
import org.hamcrest.Matcher;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import static org.hamcrest.MatcherAssert.assertThat;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 26.06.15
 * Time: 17:35
 */
@OperClass(
        description = "Новое api. Выдаем настройки для пользователя",
        apicommand = "",
        apipath = "/api/v2/settings"
)
public class Settings extends Oper<Settings> {

    public String uid() {
        return JsonPath.read(respAsString, "$[*].uid[0]");
    }

    public String seasonsSkin() {
        return JsonPath.read(respAsString, "$[*].seasons-skin[0]");
    }

    public String colorSkin() {
        return JsonPath.read(respAsString, "$[*].color_scheme[0]");
    }


    public Settings uid(Matcher<String> matcher) {
        assertThat("Неверное значение у аттрибута <uid> ", uid(), matcher);
        return this;
    }

    public Settings seasonsSkin(Matcher<String> matcher) {
        assertThat("Неверное значение у аттрибута <seasons-skin> ", seasonsSkin(), matcher);
        return this;
    }

    public Settings colorSkin(Matcher<String> matcher) {
        assertThat("Неверное значение у аттрибута <color_scheme> ", colorSkin(), matcher);
        return this;
    }


}