package ru.yandex.autotests.innerpochta.wmi.core.oper.onlyapi;

import ch.ethz.ssh2.Connection;
import ru.yandex.autotests.innerpochta.objstruct.oper.OperClass;
import ru.yandex.autotests.innerpochta.wmi.core.obj.EmptyObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;

/**
 * Created by IntelliJ IDEA.
 * User: lanwen
 * Date: 22.03.12
 * Time: 17:02
 * <p/>
 * в sjsx нету
 */
@OperClass(
        apicommand = "settings_update_todo",
        description = "Установка настройки отображения туду спецовой ручкой"
)
public class SettingsUpdateTodo extends Oper<SettingsUpdateTodo> {
    public static final String LOCALHOST = "http://127.0.0.1";

    /**
     * CAL-4660
     * Работает только при вызове с определенных машин
     * Сделан для использования совместно с мобильной почтой
     * Тестировать вручную через команду с web-qa, wmi-qa итд
     * curl 'http://wmi-qa.yandex.ru/api/settings_update_todo?uid=137754803&show_todo=off'
     * Устанавливает настройку show_todo
     * смотреть в api/settings_setup
     *
     * @param conn  - ссш коннекшн
     * @param uid   - uid пользователя которому ставим
     * @param onOff - on или off
     * @return документ ответа
     * @throws Exception *
     */
    public static SettingsUpdateTodo settingsUpdateTodo(Connection conn, String uid, String onOff) throws IOException {
        return api(SettingsUpdateTodo.class)
                .setHost(LOCALHOST)
                .params(new EmptyObj()
                        .set("uid", uid)
                        .set("show_todo", onOff))
                .get().via(conn);
    }
}
