package ru.yandex.autotests.innerpochta.wmi.core.oper.sanitizer;

import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.specification.RequestSpecification;
import ru.yandex.qatools.allure.annotations.Attachment;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

import static com.google.common.base.Joiner.on;
import static com.jayway.restassured.RestAssured.given;
import static java.lang.String.format;
import static org.apache.commons.lang3.RandomStringUtils.randomNumeric;
import static ru.yandex.autotests.innerpochta.RestAssuredLoggingFilter.log;

/**
 * User: lanwen
 * Date: 06.11.14
 * Time: 21:19
 */
public class SanitizerApi {

    public static final String REQ_PATH_SPAM = "/spam";
    public static final String REQ_PATH_PR_HTTPS = "/pr_https";
    public static final String REQ_PATH_RCA = "/rca";
    public static final String REQ_PATH_S = "/?s=mail_secproxy";
    public static final String REQ_PATH_PROXY_S = "?s=mail_proxy";
    public static final String REQ_PING = "/ping";

    private RequestSpecification baseSanitizerSpec = new RequestSpecBuilder()
            .setContentType(ContentType.TEXT.withCharset("UTF-8"))
            .addFilter(log().pretty(true))
            .build();

    private URI baseUri;

    private SanitizerApi(URI uri) {
        this.baseUri = uri;
    }

    public static SanitizerApi sanitizer(URI uri) {
        return new SanitizerApi(uri);
    }

    @Attachment("Запрос")
    private static String content(String text) throws UnsupportedEncodingException {
        String content = URLEncoder.encode(text, "UTF-8");
        return on("&text=")
                .join(format("id=%s-%s-%s", randomNumeric(5), randomNumeric(5), "mdb150"), content);
    }

    @Attachment("Ответ от " + REQ_PATH_PR_HTTPS)
    public String prHttps(String text) throws UnsupportedEncodingException {
        return given()
                .spec(baseSanitizerSpec)
                .body(content(text)).baseUri(baseUri.toString())
                .post(REQ_PATH_PR_HTTPS).asString();
    }

    @Attachment("Ответ от " + REQ_PATH_SPAM)
    public String spam(String text) throws UnsupportedEncodingException {
        return given()
                .spec(baseSanitizerSpec)
                .body(content(text)).baseUri(baseUri.toString())
                .post(REQ_PATH_SPAM).asString();
    }

    @Attachment("Ответ от " + REQ_PATH_PROXY_S)
    public String proxy(String text) {
        return given()
                .spec(baseSanitizerSpec)
                .body(text).baseUri(baseUri.toString())
                .post(REQ_PATH_PROXY_S).asString();
    }

    @Attachment("Ответ от " + REQ_PATH_S)
    public String secproxy(String text) {
        return given()
                .spec(baseSanitizerSpec)
                .body(text).baseUri(baseUri.toString())
                .post(REQ_PATH_S).asString();
    }

    @Attachment("Ответ от " + REQ_PING)
    public String ping() {
        return given().spec(baseSanitizerSpec).baseUri(baseUri.toString()).post(REQ_PING).asString();
    }

}
