package ru.yandex.autotests.innerpochta.wmi.core.oper.shiva;

import com.jayway.restassured.builder.ResponseSpecBuilder;
import com.jayway.restassured.specification.ResponseSpecification;
import org.apache.http.HttpStatus;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.shiva.util.archiveuser.ApiUtilArchiveUser;
import ru.yandex.autotests.innerpochta.wmi.core.shiva.util.cleanarchive.ApiUtilCleanArchive;
import ru.yandex.autotests.innerpochta.wmi.core.shiva.util.freezeuser.ApiUtilFreezeUser;
import ru.yandex.autotests.innerpochta.wmi.core.shiva.util.purgearchive.ApiUtilPurgeArchive;
import ru.yandex.autotests.innerpochta.wmi.core.shiva.util.purgetransferreduser.ApiUtilPurgeTransferredUser;

import static org.hamcrest.Matchers.equalTo;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiShiva;

public class Shiva {

    public static ApiUtilFreezeUser freezeUser(HttpClientManagerRule user) {
        return apiShiva(user.account().userTicket()).util().freezeUser()
                .withUid(user.account().uid());
    }

    public static ApiUtilArchiveUser archiveUser(HttpClientManagerRule user) {
        return apiShiva(user.account().userTicket()).util().archiveUser()
                .withUid(user.account().uid());
    }

    public static ApiUtilPurgeArchive purgeArchive(HttpClientManagerRule user) {
        return apiShiva(user.account().userTicket()).util().purgeArchive()
                .withUid(user.account().uid());
    }

    public static ApiUtilCleanArchive cleanArchive(HttpClientManagerRule user) {
        return apiShiva(user.account().userTicket()).util().cleanArchive()
                .withUid(user.account().uid());
    }

    public static ApiUtilPurgeTransferredUser purgeTransferredUser(HttpClientManagerRule user) {
        return apiShiva(user.account().userTicket()).util().purgeTransferredUser()
                .withUid(user.account().uid());
    }

    public static ResponseSpecification done200() {
        return new ResponseSpecBuilder()
                .expectStatusCode(HttpStatus.SC_OK)
                .expectBody(equalTo("\"Done\""))
                .build();
    }
}
