package ru.yandex.autotests.innerpochta.wmi.core.response;

import org.w3c.dom.Element;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class MailboxListResponseItem {
    private String mid;
    private String stid;
    private String recvDate;

    public MailboxListResponseItem(Element item) {
        mid = item.getAttribute("mid");
        stid = item.getAttribute("st_id");
        recvDate = item.getAttribute("recv_date");
    }

    public String mid() {
        return mid;
    }

    public String stid() {
        return stid;
    }

    public Date recvDate() throws ParseException {
        DateFormat format  = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return format.parse(recvDate);
    }

    public Long recvDateTimestamp() throws ParseException {
        return recvDate().getTime() / 1000;
    }
}
