package ru.yandex.autotests.innerpochta.wmi.core.rules;

import org.junit.runner.Description;
import ru.yandex.autotests.innerpochta.wmi.core.base.anno.IgnoreForPg;
import ru.yandex.autotests.innerpochta.wmi.core.base.anno.Scope;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Scopes;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;

import static java.util.Arrays.asList;
import static org.hamcrest.CoreMatchers.describedAs;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assume.assumeThat;
import static org.junit.Assume.assumeTrue;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 08.04.16
 * Time: 14:18
 */
public class IgnoreRule extends TestWatcherWithExceptions {
    public static IgnoreRule newIgnoreRule() {
    return new IgnoreRule();
}

    @Override
    protected void starting(Description description) {
        if (hasAnnotation(description, IgnoreForPg.class)) {
            assumeThat("Тест(ы) не для pg", props().isPg(), describedAs("testing.scope=pg", is(false)));
        }
        if (hasAnnotation(description, Scope.class)) {
            List<Scopes> scopes =  asList(description.getAnnotation(Scope.class).value());
            String scopesDescription = String.join(",", scopes.stream()
                    .map(Scopes::getName)
                    .collect(Collectors.toList()));
            assumeTrue("Тест(ы) для scope in {" + scopesDescription + "}. Текущий scope: " + props().scope(),
                    scopes.contains(props().scope()));
        }
    }

    private boolean hasAnnotation(Description description, Class<? extends Annotation> annotation) {
        return description.getAnnotation(annotation) != null;
    }


}