package ru.yandex.autotests.innerpochta.wmi.core.rules;

import org.junit.runner.Description;

import ru.yandex.autotests.innerpochta.wmi.core.base.anno.IgnoreSshTest;

import java.lang.annotation.Annotation;

import static org.junit.Assume.assumeFalse;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

public class IgnoreSshTestRule extends TestWatcherWithExceptions {
    public static IgnoreSshTestRule newIgnoreSshTestRule() {
        return new IgnoreSshTestRule();
    }

    @Override
    protected void starting(Description description) {
        if (hasAnnotation(description, IgnoreSshTest.class)) {
            assumeFalse("Ssh тест проигнорирован", props().ignoreSshTests());
        }
    }

    private boolean hasAnnotation(Description description, Class<? extends Annotation> annotation) {
        return description.getAnnotation(annotation) != null;
    }
}