package ru.yandex.autotests.innerpochta.wmi.core.rules;

import org.eclipse.jetty.http.HttpStatus;
import ru.yandex.autotests.innerpochta.wmi.core.oper.ComposeCheck;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.05.15
 * Time: 16:32
 */
public class InitialComposeCheck {
    private HttpClientManagerRule authClient;
    private ComposeCheck composeCheck = null;

    public InitialComposeCheck(HttpClientManagerRule authClient) {
        this.authClient = authClient;
    }

    public InitialComposeCheck update() {
        try {
            composeCheck = api(ComposeCheck.class).log(log().onlyIfError()).post().via(authClient.authHC())
                    .statusCodeShouldBe(HttpStatus.OK_200);
        } catch (Exception e) {
            throw new RuntimeException("Не удалось получить информацию о пользователе", e);
        }
        return this;
    }

    public ComposeCheck get() {
        if (composeCheck == null) {
            update();
        }
        return composeCheck;
    }

    public String getComposeCheckNodeValue() {
        return get().getComposeCheckNodeValue();
    }

    public String getMDB() {
        return get().getMDB();
    }

    public String getUid() {
        return get().getUid();
    }

    public String getSuid() {
        return get().getSuid();
    }

    public String getLogin() {
        return get().getLogin();
    }
}