package ru.yandex.autotests.innerpochta.wmi.core.rules;

import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 27.05.15
 * Time: 17:11
 */
public class InitialFolderList {
    private HttpClientManagerRule authClient;
    private FolderList folderList;

    public InitialFolderList(HttpClientManagerRule authClient) {
        this.authClient = authClient;
    }

    public InitialFolderList update() {
        try {
            folderList = api(FolderList.class).log(log().onlyIfError()).post().via(authClient.authHC());
        } catch (Exception e) {
            throw new RuntimeException("Не удалось получить список папок", e);
        }
        return this;
    }

    public FolderList get() {
        if (folderList == null) {
            update();
        }
        return folderList;
    }

    public String defaultFID() {
        return get().defaultFID();
    }

    public String sentFID() {
        return get().sentFID();
    }

    public String draftFID() {
        return get().draftFID();
    }

    public String templateFID() {
        return get().templateFID();
    }

    public String outgoingFID() {
        return get().outgoingFID();
    }

    public String spamFID() {
        return get().spamFID();
    }

    public String deletedFID() {
        return get().deletedFID();
    }

    public String defaultName() {
        return get().defaultName();
    }

    public String sentName() {
        return get().sentName();
    }

    public String draftName() {
        return get().draftName();
    }

    public String templateName() {
        return get().templateName();
    }

    public String outgoingName() {
        return get().outgoingName();
    }

    public String spamName() {
        return get().spamName();
    }

    public String deletedName() {
        return get().deletedName();
    }

}
