package ru.yandex.autotests.innerpochta.wmi.core.rules;

import ru.yandex.autotests.innerpochta.wmi.core.oper.Labels;
import ru.yandex.autotests.innerpochta.wmicommon.WmiConsts;

import static ru.yandex.autotests.innerpochta.beans.labels.LabelSymbol.PRIORITY_HIGH;
import static ru.yandex.autotests.innerpochta.beans.labels.LabelSymbol.PINNED_LABEL;
import static ru.yandex.autotests.innerpochta.beans.labels.LabelSymbol.ANSWERED;
import static ru.yandex.autotests.innerpochta.beans.labels.LabelSymbol.FORWARDED_LABEL;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 24.08.15
 * Time: 19:05
 */
public class InitialLabels {
    private HttpClientManagerRule authClient;
    private Labels labels;

    public InitialLabels(HttpClientManagerRule authClient) {
        this.authClient = authClient;
    }

    public InitialLabels update() {
        labels = Labels.labels().log(log().onlyIfError()).post().via(authClient.authHC());
        return this;
    }

    public Labels get() {
        if (labels == null) {
            update();
        }
        return labels;
    }

    public String fakeSeenLabel() {
        return get().lidByName(WmiConsts.FAKE_SEEN_LBL);
    }

    public String priorityHigh() {
        return get().lidBySymbol(PRIORITY_HIGH);
    }

    public String priorityHighName() {
        return get().nameBySymbol(PRIORITY_HIGH);
    }

    public String pinned() {
        return get().lidBySymbol(PINNED_LABEL);
    }

    public String answered() {
        return get().lidBySymbol(ANSWERED);
    }

    public String forwarded() {
        return get().lidBySymbol(FORWARDED_LABEL);
    }
}
