package ru.yandex.autotests.innerpochta.wmi.core.rules;

import ch.ethz.ssh2.Connection;
import org.apache.log4j.Logger;
import org.junit.rules.ExternalResource;
import ru.yandex.autotests.innerpochta.util.ssh.SSHCommands;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

import static org.apache.commons.lang.StringUtils.isEmpty;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 19.03.13
 * Time: 14:04
 */
@Deprecated
public class SSHRule extends ExternalResource {

    private String username = "robot-gerrit";
    private String pwd = "";

    private Connection conn;
    private String serverUrl = props().betaHost();
    private Logger logger = Logger.getLogger(this.getClass());

    public SSHRule(Logger logger) {
        this.logger = logger;
    }

    public SSHRule() {
    }

    public SSHRule testUser() {
        username = props().getSshLogin();
        return this;
    }

    public SSHRule testUser(String username) {
        this.username = username;
        return this;
    }

    public SSHRule withPwd() {
        pwd = props().getSshPassword();
        return this;
    }

    @Override
    protected void before() throws Throwable {
        auth();
    }

    @Override
    protected void after() {
        close();
    }

    public Connection conn() {
        return conn;
    }

    public String serverUrl() {
        return serverUrl;
    }

    public String hostname() {
        return URI.create(serverUrl).getHost();
    }

    public SSHRule serverUrl(URI uri) {
        this.serverUrl = uri.toString();
        return this;
    }

    public SSHRule serverUrl(String uri) {
        this.serverUrl = uri;
        return this;
    }


    public String getDC() {
        return datacenter.get(hostname());
    }


    public static Map<String, String> datacenter = new HashMap<String, String>() {{
        //https://golem.yandex-team.ru/hostinfo.sbml?object=wmi-qa.yandex.ru
        //curl https://golem.yandex-team.ru/hostinfo.sbml?object=`hostname` |
        // fgrep Размеще | cut -d'>' -f5 | sed 's/<br\///'
        put("web-qa.yandex.ru", "ugr");
        put("wmi-qa.yandex.ru", "myt");
        put("verstka-qa.yandex.ru", "myt");
        put("verstka3-qa.yandex.ru", "fol");
    }};

    public void close() {
        conn.close();
    }

    public SSHRule auth() {
        if (isEmpty(pwd)) {
            String keyFilePwd = "";
//            conn = SSHCommands.getSSHConnection(hostname(), username, new File(Resources.getResource("aqua_key").getFile()), keyFilePwd, logger);
            conn = SSHCommands.getSSHConnection(hostname(), username, keyFilePwd, logger);
        } else {
            File authKey = null;
            conn = SSHCommands.getSSHConnection(hostname(), username, authKey, pwd, logger);
        }
        return this;
    }
}
