package ru.yandex.autotests.innerpochta.wmi.core.rules;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.annotations.Attachment;
import ru.yandex.qatools.allure.events.AddParameterEvent;

import static org.fest.reflect.core.Reflection.field;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 12.03.13
 * Time: 22:04
 */
public class UpdateHCFieldRule extends TestWatcher {

    public static final String SSL_COOKIE_NAME = "sessionid2";
    public static final String COOKIE_NAME = "Session_id";

    private HttpClientManagerRule auth;
    private Object test;
    private String hcFieldName;

    public UpdateHCFieldRule(HttpClientManagerRule auth, Object test, String hcFieldName) {
        this.auth = auth;
        this.test = test;
        this.hcFieldName = hcFieldName;
    }

    @Override
    protected void starting(Description description) {
        LogManager.getLogger(this.getClass())
                .warn(String.format("Текущий юзер: %s", auth.acc()));

        //for allure
        Allure.LIFECYCLE.fire(new AddParameterEvent("LOGIN", auth.acc().getSelfEmail()));
        Allure.LIFECYCLE.fire(new AddParameterEvent("PASSW", auth.acc().getPassword()));

        assertThat(test, instanceOf(description.getTestClass()));
        field(hcFieldName).ofType(DefaultHttpClient.class).in(test).set(auth.authHC());

        auth.getCookieStore().getCookies().stream().filter(cookie ->
                cookie.getName().equals(SSL_COOKIE_NAME) || cookie.getName().equals(COOKIE_NAME))
                .forEach(cookie -> attachCookie(cookie.getName(), cookie.getValue()));

        if (auth.getToken() != null) {
            attachOAuth(auth.getToken());
        }
    }

    @Attachment("{0}")
    private String attachCookie(String name, String value) {
        return value;
    }

    @Attachment("OAuth")
    private String attachOAuth(String token) {
        return token;
    }
}
