package ru.yandex.autotests.innerpochta.wmi.core.rules;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.qatools.allure.Allure;
import ru.yandex.qatools.allure.events.AddParameterEvent;

import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 25.06.15
 * Time: 17:15
 */
public class WriteAllureParamsRule extends TestWatcher {

    public static WriteAllureParamsRule writeParamsForAllure() {
        return new WriteAllureParamsRule();
    }

    @Override
    protected void starting(Description description) {
        Allure.LIFECYCLE.fire(new AddParameterEvent("HOST", props().betaHost()));
        Allure.LIFECYCLE.fire(new AddParameterEvent("SCOPE", props().testingScope().getName()));
    }
}