package ru.yandex.autotests.innerpochta.wmi.core.rules.barbet;

import ru.yandex.autotests.innerpochta.beans.barbet.Primary;
import ru.yandex.autotests.innerpochta.beans.barbet.Status;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.BeforeAfterOptionalRule;
import ru.yandex.qatools.allure.annotations.Step;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiBarbet;
import static ru.yandex.autotests.innerpochta.wmi.core.barbet.BarbetResponses.ok200;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.WaitForMatcherDecorator.withWaitFor;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.barbet.BackupMatcher.backupIsInProgress;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.barbet.BackupMatcher.emptyActiveBackup;

public class CleanBackupsRule extends BeforeAfterOptionalRule<CleanBackupsRule> {
    private HttpClientManagerRule rule;

    public CleanBackupsRule(HttpClientManagerRule rule) {
        this.rule = rule;
    }

    @Step("[RULE]: Очищаем бекапы")
    @Override
    public void call() {
        try {
            assertThat("Создающийся бекап", rule, withWaitFor(not(backupIsInProgress())));

            Primary backup = apiBarbet(rule.account().userTicket())
                    .status()
                    .withUid(rule.account().uid())
                    .get(shouldBe(ok200()))
                    .as(Status.class)
                    .getPrimary();

            if (backup != null) {
                apiBarbet(rule.account().userTicket())
                        .delete()
                        .withUid(rule.account().uid())
                        .post(shouldBe(ok200()));

                assertThat("Не удалось удалить бекап", rule, withWaitFor(emptyActiveBackup()));
            }
        } catch (Exception e) {
            throw new RuntimeException("Невозможно выполнить очистку бекапов: " + e.getMessage() , e);
        }
    }
}
