package ru.yandex.autotests.innerpochta.wmi.core.rules.barbet;

import ru.yandex.autotests.innerpochta.beans.hound.ArchiveState;
import ru.yandex.autotests.innerpochta.beans.hound.ArchiveStatus;
import ru.yandex.autotests.innerpochta.wmi.core.oper.akita.UidAndTvmTicket;
import ru.yandex.autotests.innerpochta.wmi.core.oper.shiva.Shiva;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.BeforeAfterOptionalRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.Objects;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiBarbet;
import static ru.yandex.autotests.innerpochta.wmi.core.api.WmiApis.apiHoundV2;
import static ru.yandex.autotests.innerpochta.wmi.core.hound.HoundResponses.ok200;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.WaitForMatcherDecorator.withWaitFor;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.barbet.ArchiveMatcher.archiveIsInState;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.barbet.ArchiveMatcher.getArchiveStatus;

public class RecoveryUserRule extends BeforeAfterOptionalRule<RecoveryUserRule> {
    private final HttpClientManagerRule rule;

    public RecoveryUserRule(HttpClientManagerRule rule) {
        this.rule = rule;
    }

    @Step("[RULE]: Приводим пользователя в состояние active, попутно решая вопрос с архивом")
    @Override
    public void call() {
        try {
            ArchiveStatus status = getArchiveStatus(rule);
            UidAndTvmTicket acc = rule.account();
            if (Objects.equals(status.getUserState(), ArchiveStatus.UserState.ACTIVE)) {
                if (Objects.equals(status.getArchiveState(), ArchiveState.ARCHIVATION_IN_PROGRESS)) {
                    Shiva.purgeArchive(rule).get(shouldBe(Shiva.done200()));
                }
            }

            assertThat("Создающийся архив", rule, withWaitFor(not(archiveIsInState(ArchiveState.ARCHIVATION_IN_PROGRESS))));
            assertThat("Восстанавливающийся архив", rule, withWaitFor(not(archiveIsInState(ArchiveState.RESTORATION_IN_PROGRESS))));

            status = getArchiveStatus(rule);
            if (Objects.equals(status.getUserState(), ArchiveStatus.UserState.FROZEN)) {
                apiHoundV2(acc.userTicket()).unfreezeUser().withUid(acc.uid()).get(shouldBe(ok200()));
            }

            if (Objects.equals(status.getArchiveState(), ArchiveState.RESTORATION_COMPLETE)) {
                Shiva.purgeArchive(rule).get(shouldBe(Shiva.done200()));
            }

            if (Objects.equals(status.getArchiveState(), ArchiveState.CLEANING_REQUESTED) ||
                    Objects.equals(status.getArchiveState(), ArchiveState.CLEANING_IN_PROGRESS)) {
                Shiva.cleanArchive(rule).get(shouldBe(Shiva.done200()));
            }

            if (Objects.equals(status.getUserState(), ArchiveStatus.UserState.ARCHIVED) &&
                    Objects.equals(status.getArchiveState(), ArchiveState.ARCHIVATION_COMPLETE)) {

                apiBarbet(acc.userTicket()).archive().discard()
                        .withUid(acc.uid()).post(shouldBe(ok200()));
                Shiva.cleanArchive(rule).get(shouldBe(Shiva.done200()));
            }

            assertThat("Архив не удалился", rule, withWaitFor(archiveIsInState(null)));

        } catch (Exception e) {
            throw new RuntimeException("Невозможно вернуть пользователя в нормальное состояние: " + e.getMessage(), e);
        }
    }
}

