package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Oper;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsSetup;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsSetupUpdateSome;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import static org.apache.commons.lang.StringUtils.defaultIfEmpty;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsSetupUpdateSomeObj.update;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 25.03.13
 * Time: 21:32
 */
public class BackupSettingWithWmiRule extends TestWatcher {
    private DefaultHttpClient hc;
    private String settingName;
    private String backupValue;

    private String defaultValue = "";

    private String prepareValue;
    private boolean needPrepare = false;

    private Oper<?> updateOper;

    public BackupSettingWithWmiRule backup(String settingName) {
        this.settingName = settingName;
        return this;
    }

    public BackupSettingWithWmiRule defaultOff() {
        defaultValue = "off";
        return this;
    }


    public BackupSettingWithWmiRule prepareAs(String value) {
        needPrepare = true;
        prepareValue = value;
        return this;
    }

    private BackupSettingWithWmiRule(DefaultHttpClient hc) {
        this.hc = hc;
    }

    private BackupSettingWithWmiRule setUpdateOper(Oper<?> updateOper) {
        this.updateOper = updateOper;
        return this;
    }

    public static BackupSettingWithWmiRule with(HttpClientManagerRule authClient) {
        return new BackupSettingWithWmiRule(authClient.authHC())
                .setUpdateOper(
                        jsx(SettingsSetupUpdateSome.class)
                                .log(log().onlyIfErrorOrXmlWithError())
                );
    }

    @Override
    protected void starting(Description description) {
        backupValue = defaultIfEmpty(api(SettingsSetup.class)
                .log(log().onlyIfErrorOrXmlWithError())
                .get().via(hc).getSettingValue(settingName), defaultValue);

        if (needPrepare) {
            updateOper
                    .params(update(settingName, prepareValue))
                    .post().via(hc);
        }
    }

    @Override
    protected void finished(Description description) {
        updateOper
                .params(update(settingName, backupValue))
                .post().via(hc);
    }
}
