package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsFolderClear;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static java.util.concurrent.TimeUnit.MINUTES;
import static org.apache.commons.lang.StringUtils.isEmpty;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.IsNot.not;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.WaitForMatcherDecorator.withWaitFor;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.messages.IsThereMsgsMatcher.hasMsgIn;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.messages.IsThereMsgsMatcher.hasMsgsIn;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderClearObj.clearBySubj;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderClearObj.purgeFid;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 30.03.13
 * Time: 19:14
 */
public class CleanMessagesRule extends BeforeAfterOptionalRule<CleanMessagesRule> {

    private boolean all = false;
    private DefaultHttpClient hc;

    private String subject;
    private List<String> fidsToClean = new ArrayList<>();

    private static final long WAIT_TIME = MINUTES.toMillis(10);
    private boolean shouldWait = false;

    public FolderList getFolderList() {
        FolderList folderList;
        try {
            folderList = api(FolderList.class).post().via(hc);
        } catch (Exception e) {
            throw new RuntimeException("Не удалось получить список папок", e);
        }
        return folderList;
    }

    public static CleanMessagesRule with(HttpClientManagerRule authClient) {
        return new CleanMessagesRule(authClient.authHC());
    }

    private CleanMessagesRule(DefaultHttpClient hc) {
        this.hc = hc;
    }

    public CleanMessagesRule fid(String... fid) {
        return fids(Arrays.asList(fid));
    }

    public CleanMessagesRule fids(List<String> fids) {
        fidsToClean.addAll(fids);
        return this;
    }

    public CleanMessagesRule subject(final String subject) {
        this.subject = subject;
        this.all = false;
        return this;
    }

    public CleanMessagesRule all() {
        this.all = true;
        return this;
    }

    public CleanMessagesRule folder(String name) {
            fid(getFolderList().getFolderId(name));
            return this;
    }


    public CleanMessagesRule allfolders() {
        try {
            fids(api(FolderList.class).log(log().onlyIfErrorOrXmlWithError())
                    .post().via(hc).getAllFolderIds());
            return this;
        } catch (Exception e) {
            throw new RuntimeException("Невозможно получить fid'ы папок", e);
        }
    }

    public CleanMessagesRule inbox() {
        return fid(getFolderList().defaultFID());
    }

    public CleanMessagesRule outbox() {
        return fid(getFolderList().sentFID());
    }

    public CleanMessagesRule draft() {
        return fid(getFolderList().draftFID());
    }

    public CleanMessagesRule deleted() {
        return fid(getFolderList().deletedFID());
    }

    public CleanMessagesRule shouldWait(boolean v) {
        this.shouldWait = v;
        return this;
    }

    @Step("[RULE]: Очищаем папки")
    @Override
    public void call() {
        try {
            LogManager.getLogger(this.getClass()).debug("---------------CLEARING---------------");
            SettingsFolderClear clearOper = jsx(SettingsFolderClear.class)
                    .log(log());

            boolean success = true;
            if (all) {
                for (String fid : fidsToClean) {
                    if (clearOper.params(purgeFid(fid)).post().via(hc).statusLine().getStatusCode() != 200) {
                        success = false;
                    }
                }

                if (!success) {
                    return;
                }

                if (shouldWait) {
                    for (String fid : fidsToClean) {
                        assertThat(hc, withWaitFor(not(hasMsgsIn(fid)), WAIT_TIME));
                    }
                }
            } else if (!isEmpty(subject)) {
                for (String fid : fidsToClean) {
                    if (clearOper.params(clearBySubj(fid, subject)).post().via(hc).statusLine().getStatusCode() != 200) {
                        success = false;
                    }
                }

                if (!success) {
                    return;
                }

                if (shouldWait) {
                    for (String fid : fidsToClean) {
                        assertThat(hc, withWaitFor(not(hasMsgIn(subject, fid)), WAIT_TIME));
                    }
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("Невозможно выполнить очистку папки", e);
        }
    }
}
