package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.autotests.testpers.ssh.SSHAuthRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.io.IOException;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 10.01.14
 * Time: 17:26
 */
public class CreateFileRule extends TestWatcher {
    protected final Logger logger = LogManager.getLogger(this.getClass());

    private SSHAuthRule sshRule;
    private String fullPath;
    private String text;

    public CreateFileRule(SSHAuthRule sshRule) {
        this.sshRule = sshRule;
    }

    public CreateFileRule path(String path) {
        this.fullPath = path;
        return this;
    }

    public CreateFileRule text(String text) {
        this.text = text;
        return this;
    }

    /**
     * Записываем дебажное поле в дебажный файл jsx.
     * Если нет файла, то создаем его, если есть то просто переписываем.
     *
     * @param path полный путь, если файла нет, он будет создан
     * @param text текст который необходимо в него записать
     * @throws IOException
     */
    @Step("[RULE]: Создаем файл {0} с текстом {1}")
    public void createFileWithText(String path, String text) throws IOException {
        sshRule.ssh().cmd(String.format("sudo echo '%s' | sudo tee %s > /dev/null", text, path));
    }

    @Step("[RULE]: Удаляем файл {0}")
    public void deleteFile(String fullPath) throws IOException {
        sshRule.ssh().cmd("sudo rm " + fullPath);
    }

    @Override
    protected void starting(Description description) {
        try {
            createFileWithText(fullPath, text);
        } catch (IOException e) {
            throw new RuntimeException(String.format("Не удалось записать в файл %s текст <%s>", fullPath, text), e);
        }
    }

    @Override
    protected void finished(Description description) {
        try {
            deleteFile(fullPath);
        } catch (IOException e) {
            throw new RuntimeException(String.format("Невозможно выполнить удаление файла %s", fullPath), e);
        }
    }
}
