package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import ru.yandex.autotests.innerpochta.wmi.core.oper.Labels;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsLabelDelete;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.api;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.filter.log.LoggerFilterBuilder.log;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.labels.LabelCreatedMatcher.hasLabelLid;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsLabelDeleteObj.oneLid;

/**
 * Created with IntelliJ IDEA.
 * User: lanwen
 * Date: 30.03.13
 * Time: 19:14
 */
public class DeleteLabelsRule extends BeforeAfterOptionalRule<DeleteLabelsRule> {

    private DefaultHttpClient hc;
    private boolean all = false;
    private List<String> lidsToClean = new ArrayList<String>();

    public static DeleteLabelsRule with(HttpClientManagerRule authClient) {
        return new DeleteLabelsRule(authClient.authHC());
    }

    private DeleteLabelsRule(DefaultHttpClient hc) {
        this.hc = hc;
    }

    public DeleteLabelsRule lid(String... lids) {
        all = false;
        lidsToClean.addAll(Arrays.asList(lids));
        return this;
    }

    public DeleteLabelsRule labelName(final String lname) {
        lid(
                api(Labels.class)
                        .post().via(hc)
                        .lidByName(lname)
        );

        return this;
    }

    public DeleteLabelsRule all() {
        all = true;
        return this;
    }


    @Override
    protected void after() {
        call();
    }

    @Step("[RULE]: Удаляем пользовательские метки")
    @Override
    public void call() {
        try {
            LogManager.getLogger(this.getClass()).trace("---------------CLEARING Labels---------------");
            if (all) {
                lidsToClean.addAll(api(Labels.class)
                        .log(log().onlyIfErrorOrXmlWithError())
                        .post().via(hc)
                        .getAllUserLabelIds());
            }
            if (!lidsToClean.isEmpty()) {
                SettingsLabelDelete delOp = jsx(SettingsLabelDelete.class);
                // Последовательно удаляем все
                for (String lid : lidsToClean) {
                    delOp.params(oneLid(lid)).log(log().onlyIfErrorOrXmlWithError()).post().via(hc);
                }
            }

        } catch (Exception e) {
            throw new RuntimeException("Невозможно выполнить удаление меток", e);
        }
    }
}
