package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import ch.lambdaj.function.convert.StringConverter;
import org.apache.log4j.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.autotests.innerpochta.wmi.core.consts.Logs;
import ru.yandex.autotests.testpers.ssh.SSHAuthRule;
import ru.yandex.autotests.testpers.ssh.Ssh;
import ru.yandex.qatools.allure.annotations.Attachment;
import ru.yandex.qatools.allure.annotations.Step;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

import static ch.lambdaj.collection.LambdaCollections.with;
import static java.lang.String.format;
import static org.apache.commons.lang3.StringUtils.defaultIfBlank;
import static org.apache.commons.lang3.Validate.notNull;
import static org.hamcrest.Matchers.not;
import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 25.06.15
 * Time: 14:58
 */
public class LogCollectRule extends TestWatcher {

    public static final String EMPTY_COMMAND = "";

    private final Logger logger = Logger.getLogger(this.getClass());

    private SSHAuthRule sshSupplier;
    private List<Logs> forGrep = new ArrayList<>();

    private Callable<String> grepGetter = new Callable<String>() {
        @Override
        public String call() throws Exception {
            return Ssh.time();
        }
    };

    private String command;

    protected LogCollectRule(SSHAuthRule sshSupplier) {
        this.sshSupplier = sshSupplier;
        this.command = EMPTY_COMMAND;
    }

    public static LogCollectRule bySSH(SSHAuthRule sshSupplier) {
        return new LogCollectRule(sshSupplier);
    }


    public static LogCollectRule withGrepAllLogsFor(SSHAuthRule sshSupplier) {
        return new LogCollectRule(sshSupplier);
    }

    public LogCollectRule grepLog(Logs log) {
        forGrep.add(log);
        return this;
    }

    public LogCollectRule grepAllLogs() {
        for (Logs log : Logs.values()) {
            grepLog(log);
        }
        return this;
    }

    public LogCollectRule grepFor(Callable<String> how) {
        this.grepGetter = how;
        return this;
    }

    public LogCollectRule addCommand(String command) {
        this.command = command;
        return this;
    }

    public List<String> grepForString(String tail) throws Exception {
        List<String> greps = new ArrayList<>();
        String forWhat = grepGetter.call();
        for (Map.Entry<String, Logs> entry : grep(forWhat, tail, forGrep).entrySet()) {
            greps.add(attachLog(Ssh.time(), forWhat, entry.getValue().path(), entry.getKey()));
        }
        return greps;
    }

    /**
     * Делаем из списка путей мапу [что нагрепали -> путь], оставляя только те где ключ не пустой
     *
     * @param forWhat - на что грепаем
     * @param paths   - список путей для грепа
     * @return MAP[что нагрепали -> путь]
     */
    @Step("[SSH]: Грепаем логи по - {0} + {1}")
    private Map<String, Logs> grep(final String forWhat, final String command, final List<Logs> paths) {
        return with(paths).map(new StringConverter<Logs>() {
            @Override
            public String convert(Logs log) {
                try {
                    return defaultIfBlank(notNull(sshSupplier.ssh(), "SSH сессия не установлена!")
                            .cmd(format("grep %s \"%s\" \"%s\" %s", log.grepArgs(), forWhat, log.path(), command)), "");
                } catch (IOException e) {
                    logger.error(format("Can't grep: %s", log), e);
                    return "";
                }
            }
        }).retainKeys(not(""));
    }


    /**
     * Метод должен быть внешним, чтобы прикрепить аттачи к тест-кейсу
     *
     * @param time    - время грепа логов (обычно текущее)
     * @param forWhat - на что грепаем
     * @param path    - по какому пути
     * @param content - что нагрепали (не участвует в имени)
     * @return content
     */
    @Attachment("[{0}]: <{1}> in {2}")
    private String attachLog(String time, String forWhat, String path, String content) {
        return content;
    }

    public static Callable<String> forWhat() {
        return new Callable<String>() {
            @Override
            public String call() throws Exception {
                return props().getCurrentRequestId();
            }
        };
    }

    @Override
    protected void failed(Throwable e, Description description) {
        try {
            grepForString(command);
        } catch (Exception e1) {
            logger.error("", e1);
        }
    }
}