package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import ch.ethz.ssh2.LocalPortForwarder;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.HttpSchemes;
import org.junit.rules.ExternalResource;
import ru.yandex.autotests.innerpochta.wmi.core.rules.SSHRule;

import javax.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;

import static java.lang.String.format;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 07.08.14
 * Time: 17:10
 */
public class SshLocalPortForwardingRule extends ExternalResource {

    private SSHRule sshRule = new SSHRule(Logger.getLogger(this.getClass()));
    private Logger logger;

    private int localPort;
    private int remotePort;
    private String hostToForward;

    private LocalPortForwarder forwarder;


    private SshLocalPortForwardingRule(URI uri) {
        sshRule.serverUrl(uri);
        logger = LogManager.getLogger(this.getClass());
    }
    
    public SshLocalPortForwardingRule withUser(String login) {
        sshRule.testUser(login);
        return this;
    }
    
    @Override
    protected void before() throws Throwable {
        sshRule.auth();
        logger.info(format("Try to create port forwarding: `ssh %s -l %s -f -N -L %s:%s:%s`",
                sshRule.conn().getHostname(), "root",
                localPort, hostToForward, remotePort
        ));

        forwarder = sshRule.conn().createLocalPortForwarder(localPort, hostToForward, remotePort);
    }

    @Override
    protected void after() {
        try {
            if (forwarder != null) {
                forwarder.close();
            }
        } catch (IOException e) {
            throw new RuntimeException("Can't cancel local port forwarding", e);
        } finally {
            sshRule.close();
        }
    }

    public SshLocalPortForwardingRule forwardTo(URI uri) {
        hostToForward = uri.getHost();
        remotePort = uri.getPort();
        return this;
    }


    public SshLocalPortForwardingRule forwardToHost(String host) {
        hostToForward = host;
        return this;
    }

    public SshLocalPortForwardingRule withForwardToPort(int port) {
        remotePort = port;
        return this;
    }


    public SshLocalPortForwardingRule onLocalPort(int port) {
        localPort = port;
        return this;
    }

    public URI local() {
        InetSocketAddress local = forwarder.getLocalSocketAddress();
        return UriBuilder.fromPath("").host(local.getHostName()).port(local.getPort()).scheme(HttpSchemes.HTTP).build();
    }

    public static SshLocalPortForwardingRule viaRemoteHost(URI uri) {
        return new SshLocalPortForwardingRule(uri);
    }

}
