package ru.yandex.autotests.innerpochta.wmi.core.rules.local;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import ru.yandex.autotests.innerpochta.wmi.core.rules.SSHRule;

import java.io.IOException;
import java.util.ArrayList;

import static ru.yandex.autotests.innerpochta.util.ssh.SSHCommands.*;
import static ru.yandex.autotests.innerpochta.wmicommon.Util.getRandomString;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 17.11.13
 * Time: 22:04
 *
 * http://linux-commands-examples.com/tcpdump
 */
public class TcpdumpRule extends TestWatcher {

    protected final Logger logger = LogManager.getLogger(this.getClass());

    public static final String PATH_TO_LOG = "/tmp/tcpdump" + getRandomString();

    private StringBuilder cmd = new StringBuilder("sudo /usr/sbin/tcpdump -s 0 -A -nnp -q");

    private SSHRule sshRule = new SSHRule(logger);

    public TcpdumpRule(SSHRule sshRule) {
        this.sshRule = sshRule;
    }

    public TcpdumpRule host(String host) {
        addParam(cmd, "host", host);
        return this;
    }

    public TcpdumpRule port(Integer port) {
        addParam(cmd, "port", port.toString());
        return this;
    }

    public TcpdumpRule and() {
        addParam(cmd, "and");
        return this;
    }

    public TcpdumpRule iface(String iface) {
        addParam(cmd, "-i", iface);
        return this;
    }


    @Override
    protected void starting(Description description) {
        startTcpdump();
    }

    @Override
    protected void finished(Description description) {
        finishTcpdump();
        deleteLog();
    }

    private void addParam(StringBuilder buf, String param, String val) {
        addParam(buf, param);
        buf.append(' ').append(val);
    }

    private void addParam(StringBuilder buf, String param) {
        buf.append(' ').append(param);
    }

    private String getCommand() {
        //для записи в лог
        addParam(cmd, "-U");
        addParam(cmd, "-w", PATH_TO_LOG);
        return cmd.toString();
    }

    public void deleteLog() {
            logger.warn("Удаляем файл " + PATH_TO_LOG);
            rm(sshRule.conn(), logger, PATH_TO_LOG);
    }

    /**
     * Запускаем tcpdump
     *
     * @return pid процесса
     */
    public void startTcpdump() {

        try {
            String command = getCommand();
            logger.warn("Запускаем tcpdump: " + command);
            executeComm(sshRule.conn(), command, logger);
        } catch (IOException e) {
            logger.error("Не удалось запустить tcpdump");
        }
    }

    public void finishTcpdump() {
        try {
            logger.warn("Завершаем tcpdump\n" +
                    executeCommAndResturnResultAsString(sshRule.conn(), "sudo ps -A | grep tcp", logger));
        } catch (IOException e) {
            logger.error("Не удалось завершить tcpdump\n " + e.toString());
        }
        psKill(sshRule.conn(), PATH_TO_LOG, logger);
    }

    public String grepFromLog(String var) throws IOException {
        logger.warn(String.format("Ищем, сколько раз в логе %s встречается строчка: %s", PATH_TO_LOG, var));

        return executeCommAndResturnResultAsString(sshRule.conn(), String.format(
                "sudo /usr/sbin/tcpdump  -A -s0 -r %s | grep -c '%s'", PATH_TO_LOG, var), logger);
    }

    public String getLog() throws IOException {
        return executeCommAndResturnResultAsString(sshRule.conn(),
                String.format("sudo /usr/sbin/tcpdump  -A -s0 -N -q -r %s", PATH_TO_LOG), logger);
    }

    public String grepStringFromLog(String toGrep) throws IOException {
        logger.warn(String.format("Ищем в логе %s строчки, содержащие %s", PATH_TO_LOG, toGrep));

        return executeCommAndResturnResultAsString(sshRule.conn(),
                String.format("sudo /usr/sbin/tcpdump  -A -s0 -N -q -r %s | grep '%s'", PATH_TO_LOG, toGrep), logger);
    }
}

