package ru.yandex.autotests.innerpochta.wmi.core.rules.mock;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 24.04.15
 * Time: 19:53
 */
public class IptablesHelper {
    private StringBuilder cmd = new StringBuilder("sudo /sbin/iptables");
    private StringBuilder cmd6 = new StringBuilder("sudo /sbin/ip6tables");

    public IptablesHelper nat() {
        addParam("-t", "nat");
        return this;
    }

    public IptablesHelper append() {
        addParam("-A", "OUTPUT");
        return this;
    }

    public IptablesHelper delete() {
        addParam("-D", "OUTPUT");
        return this;
    }

    public IptablesHelper host(String host) {
        addParam("-p", "tcp");
        addParam("-d", host);
        return this;
    }

    public IptablesHelper port(Integer port) {
        addParam("--dport", port.toString());
        return this;
    }

    public IptablesHelper reject() {
        addParam("-j", "REJECT");
        return this;
    }

    public IptablesHelper toDestination(String hostOnRemote, Integer port) {
        addParam("-j", "DNAT");
        addParam(String.format("--to-destination %s:%d", hostOnRemote, port));
        return this;
    }

    public IptablesHelper and() {
        addParam("and");
        return this;
    }

    private void addParam(String param, String val) {
        addParam(param);
        cmd.append(' ').append(val);
        cmd6.append(' ').append(val);
    }

    private void addParam(String param) {
        cmd.append(' ').append(param);
        cmd6.append(' ').append(param);
    }

    public String getCommand() {
        return cmd.toString();
    }

    public String getCommand6() {
        return cmd6.toString();
    }
}
