package ru.yandex.autotests.innerpochta.wmi.core.rules.mock.handlers;

import org.apache.mina.core.service.IoHandlerAdapter;
import org.apache.mina.core.session.IoSession;

import java.util.logging.Logger;

import static ru.yandex.autotests.innerpochta.wmi.core.base.props.WmiCoreProperties.props;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 28.04.15
 * Time: 20:53
 */
public class SmtpMinaServerHandler extends IoHandlerAdapter {

    public void sessionOpened(IoSession session) {
        session.write(String.format("220 %s ESMTP Yandex", props().betaHost()));
    }

    public void messageReceived(IoSession session, Object message) {
        switch (((String) message).trim()) {
            case "EHLO 127.0.0.1":
                session.write(String.format(
                        "250-%s\n" +
                                "250-PIPELINING\n" +
                                "250-SIZE 42991616\n" +
                                "250-VRFY\n" +
                                "250-ETRN\n" +
                                "250-ENHANCEDSTATUSCODES\n" +
                                "250-8BITMIME\n" +
                                "250 DSN", props().betaHost()));
                break;

            case "RCPT TO: <mocksmtspervicetest%yandex.ru@mxbacks.mail.yandex.net>":
                session.write("250 2.1.0 Ok");
                break;

            case "MAIL FROM: <mocksmtspervicetest@yandex.ru>":
                session.write("454 4.7.1 <mocksmtspervicetest%yandex.ru@mxbacks.mail.yandex.net>: Relay access denied");
                break;
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        super.messageSent(session, message);
    }
}