package ru.yandex.autotests.innerpochta.wmi.core.rules.mops;

import org.seleniumhq.jetty7.http.HttpStatus;
import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.Mops;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.source.FidSource;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.BeforeAfterOptionalRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.ArrayList;
import java.util.List;

import static java.util.concurrent.TimeUnit.MINUTES;
import static java.util.function.Function.identity;
import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.IsNot.not;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.WaitForMatcherDecorator.withWaitFor;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.messages.IsThereMessagesMatcher.hasMsgsIn;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders.folders;


public class CleanMessagesMopsRule extends BeforeAfterOptionalRule<CleanMessagesMopsRule> {
    private List<Symbol> symbolsToClean = new ArrayList<>();
    private HttpClientManagerRule rule;
    private boolean cleanAllFolders = false;
    private static final long WAIT_TIME = MINUTES.toMillis(10);

    public static CleanMessagesMopsRule with(HttpClientManagerRule rule) {
        return new CleanMessagesMopsRule(rule);
    }

    public CleanMessagesMopsRule(HttpClientManagerRule rule) {
        this.rule = rule;
    }

    public CleanMessagesMopsRule allfolders() {
        cleanAllFolders = true;
        return this;
    }

    public CleanMessagesMopsRule inbox() {
        symbolsToClean.add(Symbol.INBOX);
        return this;
    }

    public CleanMessagesMopsRule outbox() {
        symbolsToClean.add(Symbol.OUTBOX);
        return this;
    }

    public CleanMessagesMopsRule draft() {
        symbolsToClean.add(Symbol.DRAFT);
        return this;
    }

    public CleanMessagesMopsRule deleted() {
        symbolsToClean.add(Symbol.TRASH);
        return this;
    }

    public CleanMessagesMopsRule template() {
        symbolsToClean.add(Symbol.TEMPLATE);
        return this;
    }

    @Step("[RULE]: Очищаем папки")
    @Override
    public void call() {
        try {
            Folders f = folders(FoldersObj.empty().withHidden().setUid(rule.account().uid())).get().via(rule);

            List<String> fids;
            if (cleanAllFolders) {
                fids = f.fids();
            } else {
                fids = new ArrayList<>();

                for (int i = 0; i < symbolsToClean.size(); i++) {
                    String fid = f.fid(symbolsToClean.get(i));
                    if (fid != null) {
                        fids.add(fid);
                    }
                }
            }

            boolean shouldWait = false;
            for (String fid : fids) {
                String type = Mops.purge(rule, new FidSource(fid))
                        .post(identity()).then()
                        .assertThat().statusCode(HttpStatus.OK_200).contentType("application/json")
                        .extract().body().jsonPath().getString("taskType");
                shouldWait = shouldWait || (type.equals("async"));
            }

            if (shouldWait) {
                for (String fid : fids) {
                    assertThat(rule, withWaitFor(not(hasMsgsIn(fid)), WAIT_TIME));
                }
            }
        } catch (Exception e) {
            throw new RuntimeException("Невозможно выполнить очистку папки: " + e.getMessage() , e);
        }
    }
}
