package ru.yandex.autotests.innerpochta.wmi.core.rules.mops;

import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Hound;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.Mops;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.BeforeAfterOptionalRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import static java.util.function.Function.identity;
import static ru.yandex.autotests.innerpochta.beans.folderlist.Symbol.*;
import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.mops.MopsResponses.okSync;

public class DeleteFoldersRule extends BeforeAfterOptionalRule<DeleteFoldersRule> {
    private HttpClientManagerRule rule;
    private List<String> fidsToClean = new ArrayList<>();
    private boolean cleanAllFolders = false;

    public static DeleteFoldersRule with(HttpClientManagerRule authClient) {
        return new DeleteFoldersRule(authClient);
    }

    private DeleteFoldersRule(HttpClientManagerRule rule) {
        this.rule = rule;
    }

    public DeleteFoldersRule all() {
        cleanAllFolders = true;
        return this;
    }

    public DeleteFoldersRule symbol(Symbol symbol) {
        fidsToClean.addAll(
                Hound.folders(rule).entrySet().stream()
                        .filter(
                                entry -> entry
                                        .getValue()
                                        .getSymbolicName()
                                        .getTitle()
                                        .equals(symbol.toString())
                        )
                        .map(Map.Entry::getKey)
                        .collect(Collectors.toList())
        );
        return this;
    }

    @Step("[RULE]: Удаляем пользовательские папки")
    @Override
    public void call() {
        if (cleanAllFolders) {
            fidsToClean.addAll(
                Hound.folders(rule).entrySet().stream()
                    .filter(
                        entry -> entry
                            .getValue()
                            .getIsUser()
                            ||
                            entry
                                .getValue()
                                .getSymbolicName()
                                .getTitle()
                                .equals(ARCHIVE.toString())
                    )
                    .map(Map.Entry::getKey)
                    .collect(Collectors.toList())
            );
        }

        try {
            for (String fid : fidsToClean) {
                Mops.updateFolderSymbol(rule, fid).post(identity());
                Mops.deleteFolder(rule, fid).post(shouldBe(okSync()));
            }
        } catch (Exception e) {
            throw new RuntimeException("Невозможно выполнить очистку папки", e);
        }
    }
}
