package ru.yandex.autotests.innerpochta.wmi.core.rules.mops;

import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.LabelsObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.Mops;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;
import ru.yandex.autotests.innerpochta.wmi.core.rules.local.BeforeAfterOptionalRule;
import ru.yandex.qatools.allure.annotations.Step;

import java.util.List;

import static ru.yandex.autotests.innerpochta.wmi.core.api.CommonApiSettings.shouldBe;
import static ru.yandex.autotests.innerpochta.wmi.core.mops.MopsResponses.okSync;
import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Labels.labels;

public class DeleteLabelsMopsRule extends BeforeAfterOptionalRule<DeleteLabelsMopsRule> {
    private HttpClientManagerRule rule;

    public DeleteLabelsMopsRule(HttpClientManagerRule rule) {
        this.rule = rule;
    }

    @Override
    protected void after() {
        call();
    }

    @Step("[RULE]: Удаляем пользовательские метки")
    @Override
    public void call() {
        try {
            List<String> lids = labels(LabelsObj.empty().setUid(rule.account().uid())).get().via(rule).userLids();

            for (String lid : lids) {
                Mops.deleteLabel(rule, lid).post(shouldBe(okSync()));
            }
        } catch (Exception e) {
            throw new RuntimeException("Невозможно выполнить удаление меток", e);
        }
    }
}
