package ru.yandex.autotests.innerpochta.wmi.core.sendbernar;


import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import ru.yandex.autotests.innerpochta.beans.mbody.NarodTransformerResult;

import java.io.IOException;
import java.util.List;

import static java.net.URLEncoder.encode;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.hasItem;
import static ru.yandex.autotests.innerpochta.wmi.core.utils.AttachUtils.fromClasspath;
import static org.apache.commons.lang.RandomStringUtils.randomAlphanumeric;


public class DiskAttachHelper {
    private String diskHost;
    private String diskPath;
    private String link;
    private String previewHost;
    private String previewPath;
    private String dataPreview;
    private String hash;
    private String name;
    private String size;
    private String html;
    private String json;

    public DiskAttachHelper() throws IOException {
        this(false);
    }

    public static DiskAttachHelper withHashInUrl() throws IOException {
        return new DiskAttachHelper(true);
    }

    private DiskAttachHelper(boolean hashInUrl) throws IOException {
        hash = randomAlphanumeric(16);
        diskHost = "https://yadi.sk";
        diskPath = "/mail";
        if (hashInUrl) {
            diskPath+= "?hash=" + hash;
        }
        link = diskHost + diskPath;

        name = "Горы.jpg";

        previewHost = "https://downloader.disk.yandex.ru";
        previewPath = new StringBuilder("/preview/")
                .append(randomAlphanumeric(64))
                .append("?uid=0&filename=")
                .append(name)
                .append("&disposition=inline&hash=&")
                .append("limit=0&content_type=image/jpeg&tknv=v2&size=S&crop=0").toString();
        dataPreview = previewHost + previewPath;

        size = "1762478";
        String hashDataAttr = hashInUrl ? "" : hash;
        html = String.format(fromClasspath("sendbernar/disk_attach.html"), link, encode(dataPreview, "UTF-8"), hashDataAttr, name, size);
        json = String.format(fromClasspath("sendbernar/disk_attach.json"), diskPath, name, previewPath, size, hashDataAttr);
    }

    public String getHtml() {
        return html;
    }

    public String getJson() {
        return json;
    }

    public String getHash() {
        return hash;
    }

    private static class AttachMatches extends TypeSafeDiagnosingMatcher<NarodTransformerResult> {
        private final DiskAttachHelper helper;

        @Override
        protected boolean matchesSafely(NarodTransformerResult att, Description description) {
            description.appendText("but was: " + att.toString());
            return att.getPartClassInfo().getPartClass().equals("image")
                    && att.getSizeDescription().equals(helper.size)
                    && att.getUrl().equals(helper.link)
                    && att.getHash().equals(helper.hash)
                    && att.getPreview().equals(helper.dataPreview);
        }

        @Override
        public void describeTo(Description description) {
            description.appendText(new StringBuilder("attachment with parameters: ")
                    .append("{ partClass=image")
                    .append(", size=").append(helper.size)
                    .append(", url=").append(helper.link)
                    .append(", preview=").append(helper.dataPreview)
                    .append(", hash=").append(helper.hash)
                    .append(" }").toString());
        }

        AttachMatches(DiskAttachHelper h) {
            helper = h;
        }
    }

    private AttachMatches matchThis() {
        return new AttachMatches(this);
    }

    public void assertAttachInMessageIsSame(Message message) {
        List<NarodTransformerResult> attaches = message.getAttachments().get(0).getNarodTransformerResult();
        assertThat(attaches, hasItem(matchThis()));
    }

    public static String ruAttachesTitle = "К письму приложены файлы на Яндекс Диске:";
}




