package ru.yandex.autotests.innerpochta.wmi.core.spaniel;

import ru.yandex.autotests.innerpochta.beans.yplatform.Envelope;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class DatesWithNext {
    private List<Long> dates;
    private String next;

    public DatesWithNext(MessagesBySearchResponse response) {
        this.next = response.getNext();
        this.dates = response.getData().values().stream()
                .map(MessagesForUser::getEnvelopes)
                .flatMap(Collection::stream)
                .map(Envelope::getReceiveDate)
                .collect(Collectors.toList());
    }

    public List<Long> getDates() {
        return dates;
    }

    public String getNext() {
        return next;
    }
}