package ru.yandex.autotests.innerpochta.wmi.core.utils;

import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.LogManager;
import ru.yandex.autotests.innerpochta.wmi.core.obj.MailboxOperObj;
import ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderClearObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.FolderList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailBoxList;
import ru.yandex.autotests.innerpochta.wmi.core.oper.MailboxOper;
import ru.yandex.autotests.innerpochta.wmi.core.oper.SettingsFolderClear;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.io.IOException;

import static org.hamcrest.MatcherAssert.assertThat;
import static ru.yandex.autotests.innerpochta.wmi.core.base.Exec.jsx;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.messages.IsThereMsgsMatcher.hasMsgs;
import static ru.yandex.autotests.innerpochta.wmi.core.matchers.messages.IsThereMsgsMatcher.hasMsgsIn;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.MailBoxListObj.inFid;
import static ru.yandex.autotests.innerpochta.wmi.core.obj.SettingsFolderClearObj.clearBySubj;

/**
 * Created with IntelliJ IDEA.
 * User: vicdev
 * Date: 9/13/13
 * Time: 5:37 PM
 */
public class DeleteUtils {

    private static HttpClientManagerRule authClient;

    public static void setAuthClient(HttpClientManagerRule authClient) {
        DeleteUtils.authClient = authClient;
    }

    /**
     * Грохает все сообщения, содержащие в теме указанную строку
     * ОСТОРОЖНО: при указании пустой строки, может грохнуть лишнее
     * Есть проверка на совсем пустоту
     *
     * @param subject - тема содержит
     * @throws IOException *
     */
    @Deprecated
    public static void deleteMsgsBySubjFromInboxSent(String subject) throws IOException, InterruptedException {
        LogManager.getLogger("Clearer").trace("---------------CLEARING---------------");

        // Чтобы не удалить лишнее
        if (null == subject || subject.isEmpty()) {
            return;
        }
        FolderList folderList = jsx(FolderList.class).post().via(authClient.authHC());
        // Получаем фид
        String fidOutbox = folderList.sentFID();
        // Пробуем ждать появления задерживающихся писем
        Thread.sleep(1500);
        // Создаем настройки
        SettingsFolderClearObj clearFolder =
                clearBySubj(folderList.defaultFID(), subject);
        SettingsFolderClear clearOper = jsx(SettingsFolderClear.class).params(clearFolder);
        // Чистим входящие
        clearOper.post().via(authClient.authHC());
        Thread.sleep(1000);
        // Чистим отправленные
        clearFolder.setFid(fidOutbox);
        clearOper.post().via(authClient.authHC());
    }

    /**
     * Вызывает удаление используя аутенфицированный клиент из менеджера
     *
     * @param subject - тема письма
     * @throws Exception *
     */
    public static void deleteOneMessageBySubjFromInboxOutbox(String subject) throws Exception {
        deleteOneMessageBySubjFromInboxOutbox(subject, authClient.authHC());
    }

    /**
     * Чистим за тестом, удаляя письмо
     * Проверяем что письмо удалилось
     *
     * @param subject - Тема письма
     * @param hc      - Авторизованный httpClient4
     * @throws Exception все
     */
    public static void deleteOneMessageBySubjFromInboxOutbox(String subject, DefaultHttpClient hc) throws Exception {
        LogManager.getLogger("Clearer").trace("----------------CLEARING 1 MSG-------------------");
        // Получение фидов для использования в статическом контексте
        String fidOutbox = jsx(FolderList.class).post().via(hc).sentFID();
        // Чистка в отправленных
        String mid = jsx(MailBoxList.class)
                .params(inFid(fidOutbox))
                .post().via(hc)
                .getMidOfMessage(subject);
        if (null != mid && !mid.isEmpty()) { // Если мид пуст, то ничего делать не надо
            jsx(MailboxOper.class)
                    .params(MailboxOperObj.deleteOneMsg(mid))
                    .post().via(hc);
        }

        assertThat("Не ожидалось писем в ОТПРАВЛЕННЫХ с темой: " + subject, hc, hasMsgsIn(subject, 0, fidOutbox));

        // Чистка во Входящих
        mid = jsx(MailBoxList.class)
                .post().via(hc)
                .getMidOfMessage(subject);
        if (null != mid && !mid.isEmpty()) {    // Если мид пуст, то ничего делать не надо
            jsx(MailboxOper.class)
                    .params(MailboxOperObj.deleteOneMsg(mid))
                    .post().via(hc);
        }
        assertThat("Не ожидалось писем во ВХОДЯЩИХ с темой: " + subject, hc, hasMsgs(subject, 0));
    }
}
