package ru.yandex.autotests.innerpochta.wmi.core.utils;

import ru.yandex.autotests.innerpochta.beans.folderlist.Symbol;
import ru.yandex.autotests.innerpochta.beans.yplatform.Folder;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.FoldersObj;
import ru.yandex.autotests.innerpochta.wmi.core.oper.hound.Folders;
import ru.yandex.autotests.innerpochta.wmi.core.oper.mops.Mops;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.List;
import java.util.Map;

public class FolderList {
    private Folders folders_ = null;
    private HttpClientManagerRule authClient;

    private Folders foldersInternal() {
        if (folders_ == null) {
            folders_ = Folders.folders(FoldersObj.empty().withHidden().setUid(authClient.account().uid())).get().via(authClient);
        }

        return folders_;
    }

    public FolderList(HttpClientManagerRule rule) {
        this.authClient = rule;
    }

    public String fidBySymbol(Symbol symbol) {
        return foldersInternal().fid(symbol);
    }

    public String fidByName(String name) {
        return foldersInternal().fid(name);
    }

    public String nameBySymbol(Symbol symbol) {
        return foldersInternal().name(symbol);
    }

    public String nameByFid(String fid) {
        return foldersInternal().name(fid);
    }

    public String folderPop3(Symbol symbol) {
        return foldersInternal().folderPop3(symbol);
    }

    public List<String> nonsystemFids() {
        return foldersInternal().nonsystemFids();
    }
    public Map<String, Folder> folders() {
        return foldersInternal().folders();
    }

    public Integer count(String fid) {
        return foldersInternal().count(fid);
    }

    public Integer newCount(String fid) {
        return foldersInternal().newCount(fid);
    }

    public String symbolByFid(String fid) {
        return foldersInternal().symbolName(fid);
    }

    public String inboxFID() {
        return fidBySymbol(Symbol.INBOX);
    }

    public String defaultFID() {
        return inboxFID();
    }

    public String sentFID() {
        return fidBySymbol(Symbol.SENT);
    }

    public String outgoingFID() {
        return fidBySymbol(Symbol.OUTBOX);
    }

    public String draftFID() {
        return fidBySymbol(Symbol.DRAFT);
    }

    public String templateFID() {
        return fidBySymbol(Symbol.TEMPLATE);
    }

    public String spamFID() {
        return fidBySymbol(Symbol.SPAM);
    }

    public String deletedFID() {
        return fidBySymbol(Symbol.TRASH);
    }

    public String hiddenTrashFID() {
        return fidBySymbol(Symbol.HIDDEN_TRASH);
    }

    public String archiveFid() { return fidBySymbol(Symbol.ARCHIVE); }

    public String replyLaterFID() {
        return fidBySymbol(Symbol.REPLY_LATER);
    }

    public String getOrCreateArchiveFid() {
        return getOrCreateArchiveFid("Архив");
    }

    public String getOrCreateArchiveFid(String name) {
        String archiveFid = archiveFid();
        if(archiveFid == null) {
            archiveFid = Mops.newFolder(authClient, name, Symbol.ARCHIVE);
            folders_ = null;
        }

        return archiveFid;
    }
}
