package ru.yandex.autotests.innerpochta.wmi.core.utils;

import ru.yandex.autotests.innerpochta.wmicommon.Util;

import java.io.IOException;

import static ru.yandex.autotests.innerpochta.wmi.core.utils.AttachUtils.fromClasspath;

public class MessagesWithInlines {
    public static String getSmileHtml(int smileNumber) throws IOException {
        return String.format(fromClasspath("inline/smile.html"), smileNumber, smileNumber, smileNumber);
    }

    public static String getInlineHtml(String id, String src) throws IOException {
        return String.format(fromClasspath("inline/inline.html"), id, src, id);
    }

    public static String getRandomSmile() throws IOException {
        int num = Util.getRandomShortInt();
        return String.format(fromClasspath("inline/smile.html"), num, num, num);
    }

    public static String getRandomSmileWithHtml() throws IOException {
        int num = Util.getRandomShortInt();
        return String.format(fromClasspath("sendbernar/inline.html"), num, num, num);
    }
}
