package ru.yandex.autotests.innerpochta.wmi.core.utils;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.DefaultHttpClient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MulcagateClient {
    public class MulcagateException extends Exception {
        public MulcagateException(String message) {
            super(message);
        }

        public MulcagateException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    final String mulcagateUri;

    public MulcagateClient(String mulcagateUri) {
        this.mulcagateUri = mulcagateUri;
    }

    public String get(String stid, Long offsetBegin, Long offsetEnd) throws MulcagateException {
        try (DefaultHttpClient httpClient = new DefaultHttpClient()) {
            final String url = String.format("%s/gate/get/%s", mulcagateUri, stid);
            HttpGet request = new HttpGet(url);
            request.addHeader("Range", String.format("bytes=%d-%d", offsetBegin, offsetEnd));
            HttpResponse response = httpClient.execute(request);

            final int code = response.getStatusLine().getStatusCode();
            if (code / 100 != 2) {
                throw new MulcagateException(String.format("Bad response code from mulcagate: %d", code));
            }

            return readString(response.getEntity().getContent());
        } catch (IOException exc) {
            throw new MulcagateException("Exception in mulcagate request: " + exc.getMessage(), exc);
        }
    }

    private String readString(InputStream stream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        StringBuffer result = new StringBuffer();
        String line;
        while ((line = reader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }
}
