package ru.yandex.autotests.innerpochta.wmi.core.utils;

import ru.yandex.autotests.innerpochta.beans.yplatform.Envelope;
import ru.yandex.autotests.innerpochta.wmi.core.obj.hound.MessagesByFolderObj;
import ru.yandex.autotests.innerpochta.wmi.core.rules.HttpClientManagerRule;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

import static ru.yandex.autotests.innerpochta.wmi.core.oper.hound.MessagesByFolder.messagesByFolder;

public class WaitedMailbox {
    private HttpClientManagerRule authClient;
    private String fid;
    private String subject;

    WaitedMailbox(String subj, String fid, HttpClientManagerRule authClient) {
        this.subject = subj;
        this.authClient = authClient;
        this.fid = fid;
    }

    public String getMid() {
        return messagesByFolder(defaultParams())
                .get()
                .via(authClient)
                .firstMidBySubject(subject);
    }

    public Optional<ru.yandex.autotests.innerpochta.beans.Envelope> getEnvelope() {
        return messagesByFolder(defaultParams())
                .get()
                .via(authClient)
                .resp().getEnvelopes().stream()
                .filter(e -> e.getSubject().equals(subject))
                .findFirst();
    }

    public List<ru.yandex.autotests.innerpochta.beans.Envelope> getEnvelopes() {
        return messagesByFolder(defaultParams())
                .get()
                .via(authClient)
                .resp().getEnvelopes().stream()
                .filter(e -> e.getSubject().equals(subject))
                .collect(Collectors.toList());
    }

    public List<ru.yandex.autotests.innerpochta.beans.Envelope> getEnvelopes(String fid) {
        return messagesByFolder(defaultParams().setFid(fid))
                .get()
                .via(authClient)
                .resp().getEnvelopes().stream()
                .filter(e -> e.getSubject().equals(subject))
                .collect(Collectors.toList());
    }

    public String getTid() {
        return messagesByFolder(defaultParams())
                .get()
                .via(authClient)
                .resp().getEnvelopes().stream()
                .filter(e -> e.getSubject().equals(subject))
                .findFirst()
                .map(e -> e.getThreadId())
                .get();
    }

    public String getFirstMidIf(Predicate<Envelope> predicate) {
        return messagesByFolder(defaultParams())
                .get()
                .via(authClient)
                .firstMidIf(predicate);
    }

    public List<String> getMids() {
        return messagesByFolder(defaultParams())
                .get()
                .via(authClient)
                .resp()
                .getEnvelopes().stream()
                .filter(e -> e.getSubject().equals(subject))
                .map(e -> e.getMid())
                .collect(Collectors.toList());
    }

    private MessagesByFolderObj defaultParams() {
        return MessagesByFolderObj
                .empty()
                .setUid(authClient.account().uid())
                .setFid(fid)
                .setFirst("0")
                .setCount("10");
    }
}
