package ru.yandex.autotests.innerpochta.wmi.core.utils;

import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class ZkClient implements AutoCloseable {
    private ZooKeeper zk;
    private final CountDownLatch connectionLatch = new CountDownLatch(1);

    public ZkClient(String connStr) throws InterruptedException, IOException {
        Watcher watcher = watchedEvent -> {
            if (watchedEvent.getState() == Watcher.Event.KeeperState.SyncConnected) {
                connectionLatch.countDown();
            }
        };
        zk = new ZooKeeper(connStr, 3000, watcher);
        connectionLatch.await(15, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws InterruptedException {
        zk.close();
    }

    public List<String> getChildren(String path) throws KeeperException, InterruptedException {
        if (zk.getState().isConnected()) {
            return zk.getChildren(path, false);
        }
        return new ArrayList<>();
    }

    public void deleteChildren(String path) throws KeeperException, InterruptedException {
        if (zk.getState().isConnected()) {
            for (String child : getChildren(path)) {
                zk.delete(path + '/' + child, -1);
            }
        }
    }
}
