// **************
// HELPFUL LINKS
// **************
// https://jenkinsci.github.io/job-dsl-plugin
// https://github.yandex-team.ru/qatools/startrek-jenkins-plugin/blob/fa16a72deed91b3cab7493717a87156f63076202/README.md

freeStyleJob('xiva_doc') {
  description("""
Сборка докер-образов для сборки проектов
<br/>
Эта джоба сгенерирована автоматически. <br/>
Подробности смотреть в <a href=${JOB_URL}>Seed Job</a>
<br/>""")

  label('xiva_deb')
  logRotator(14, 200)
  concurrentBuild(false)
  parameters {
      stringParam('BRANCH', '', 'ветка в репозитории, которую собирать')
      booleanParam('CLEAN_WORKING_DIR', false, 'снести сборочную директорию. Не используется, добавлен для совместимости с CI/CD тулзой.')
  }
  environmentVariables(['project_directory': 'xiva/doc',
                        'name': 'xiva-doc'])

  wrappers {
      colorizeOutput('xterm')
      sshAgent('robot-gerrit-ssh-key')

      credentialsBinding {
          usernamePassword('DOCKER_REGISTRY_USER', 'DOCKER_REGISTRY_TOKEN', 'robot-sender-docker-registry-creds')
      }
  }

  scm {
      git {
          remote {
              url('git@bb.yandex-team.ru:mail/arcadia.git')
              credentials('robot-gerrit-ssh-key')
          }
          branch('${BRANCH}')
          extensions {
              // dot not shallow clone because shallow updates are not allowed in git repos
              submoduleOptions {
                  recursive()
              }
          }
      }
  }
  steps {
      shell('''
        DT=`date "+%Y-%m-%d-%H-%M"`;
        VERSION="${DT}"

        echo "GITTAG=${name}-${VERSION}" > variables.txt
        echo "BUILDNAME=${name}:r${VERSION}" >> variables.txt
        echo "BUILDTAG=registry.yandex.net/mail/xiva/doc:r${VERSION}" >> variables.txt
      ''')

      environmentVariables {
          propertiesFile('variables.txt')
      }

      shell('''
        pushd ${project_directory}
          rm -rf build
          docdir=build/var/xivadoc/www/
          mkdir -p ${docdir}
          ./compose.sh ${docdir}
          ./deploy.sh ${docdir}
        popd
      ''')

      shell('''
        pushd ${project_directory}
          docker build --network=host --pull --tag ${BUILDTAG} ./
          docker push ${BUILDTAG}
        popd
      ''')

      publishers {
          git {
              pushOnlyIfSuccess()
              tag('origin', '${GITTAG}') {
                  create(true)
                  update(true)
                  message('text')
              }
          }
      }
    
      publishers {
          buildDescription('', '''${BUILDTAG} ${DIGEST}''')
      }

  }

  wrappers {
    buildName('${BUILDNAME}')
  }

}
