// **************
// HELPFUL LINKS
// **************
// https://jenkinsci.github.io/job-dsl-plugin
// https://github.yandex-team.ru/qatools/startrek-jenkins-plugin/blob/fa16a72deed91b3cab7493717a87156f63076202/README.md

def create_job = { name, envs, desc ->
freeStyleJob(name) {
  description("""
Эта джоба сгенерирована автоматически. <br/>
Подробности смотреть в <a href=${JOB_URL}>Seed Job</a>
<br/>""")

  label('xiva_deb')
  logRotator {
      artifactDaysToKeep(1)
      daysToKeep(30)
  }
  concurrentBuild(false)
  environmentVariables(envs)

  wrappers {
      colorizeOutput('xterm')
      sshAgent('robot-gerrit-ssh-key')
  }

  scm {
      git {
          remote {
              url('git@bb.yandex-team.ru:mail/arcadia.git')
              credentials('robot-gerrit-ssh-key')
          }
          branch('master')
          extensions {
              // dot not shallow clone because shallow updates are not allowed in git repos
              submoduleOptions {
                  recursive()
              }
          }
      }
  }
  
  triggers {
      cron("H/2 * * * *")
  }
  
  
  steps {
      shell('''
        [[ -d ~/asg ]] && ~/asg/asg selfupdate
        [[ -d ~/asg ]] || git clone --depth 1 https://bb.yandex-team.ru/mail/asg ~/asg && ~/asg/asg-integrate-bash
      ''')

      shell('''
        function commit_hash() {
            git show  -q --format='%H' "$1"
        }
        set -eE
        rm -rf ./build
        ~/asg/asg clone ./build
        cd build/mail
        cold_start=1
        while true; do
            stored_master=$(commit_hash origin/master)
            git checkout origin/master
            ~/asg/asg rebase
            [[ "$stored_master" != "$(commit_hash origin/master)" ]] && continue # YPLATFORM-39
            # do max 15 commits in 2 minutes
            HISTORY=`git log --oneline svn..HEAD | tail -n 15 | nl | sort -n -r -k 1 | awk '{print $2}'`
            [[ -z "$(echo -ne $HISTORY)" ]] && break
            [[ $cold_start ]] || sleep 120
            unset cold_start
            git checkout svn
            for c in ${HISTORY}; do \
                { echo "Commit: $c"; \
                git cherry-pick "$c" && git commit --amend -m "$(git log --format=%B -n1)" -m "$(git show --pretty='Author: %an <%ae>' -s HEAD)" -m "__BYPASS_CHECKS__ SKIP_CHECK" && echo OK; } \
                || exit 1 ; \
            done
            git svn dcommit
        done

        [[ "$stored_master" != "$(commit_hash origin/master)" ]] && { exit 1; } # YPLATFORM-39
        { git checkout origin/master && git merge svn --ff-only && git push origin HEAD:master && exit 0; } || true
        git checkout svn
        echo "arcadia sync commit" > .git/replace-msg
        git cat-file commit HEAD | sed '1,/^$/d' | grep git-svn-id >> .git/replace-msg
        new_master=$(git commit-tree HEAD: -p HEAD^ -p origin/master < .git/replace-msg)
        git checkout origin/master
        git merge "$new_master" --ff-only
        git push origin HEAD:master
      ''')
  }

}
}

create_job('arc_dcommit', [
  'name':'arc_dcommit',
], '')
