// **************
// HELPFUL LINKS
// **************
// https://jenkinsci.github.io/job-dsl-plugin
// https://github.yandex-team.ru/qatools/startrek-jenkins-plugin/blob/fa16a72deed91b3cab7493717a87156f63076202/README.md

freeStyleJob('fan_automation') {
  description("""
Сборка докер-образов для сборки проектов
<br/>
Эта джоба сгенерирована автоматически. <br/>
Подробности смотреть в <a href=${JOB_URL}>Seed Job</a>
<br/>""")

  label('xiva_deb')
  logRotator(14, 200)
  concurrentBuild(false)

  wrappers {
      colorizeOutput('xterm')
      sshAgent('robot-gerrit-ssh-key')

      preBuildCleanup {
          deleteDirectories()
          cleanupParameter('CLEAN_WORKING_DIR')
      }

      timeout {
          absolute(minutes = 60)
      }
  }

  triggers {
      cron('0 8 * * *')
      scm('* * * * *')
  }

  scm {
      git {
          remote {
              url('git@bb.yandex-team.ru:mail/arcadia.git')
              credentials('robot-gerrit-ssh-key')
          }
          branch('master')
          extensions {
              // dot not shallow clone because shallow updates are not allowed in git repos
              submoduleOptions {
                  recursive()
              }
          }
          configure { gitScm ->
              gitScm / 'extensions' << 'hudson.plugins.git.extensions.impl.PathRestriction' {
                  includedRegions('fan/.*')
              }        
          }
          
      }
  }
  steps {
      downstreamParameterized {
          trigger('fan_ui') {
              block {
                  buildStepFailure('FAILURE')
                  failure('FAILURE')
                  unstable('UNSTABLE')
              }
              parameters {
                  predefinedProp('BRANCH', 'master')
                  predefinedProp('SKIP_PUBLISHING', 'true')
              }
          }
      }
  }

  publishers {
        extendedEmail {
            recipientList('nordsturm@yandex-team.ru')
            defaultSubject('Fan automatic build: $BUILD_STATUS')
            defaultContent('$BUILD_URL $BUILD_STATUS')
            triggers {
                fixed {
                    sendTo {
                        recipientList()
                    }
                }
                firstFailure {
                    sendTo {
                        recipientList()
                    }
                }
                firstUnstable {
                    sendTo {
                        recipientList()
                    }
                }
            }
        }
    }
}
