freeStyleJob('autotests-mail-wmi') {
    displayName('Джоба для генерации джоб из аркадии')

    label('maildev')

    parameters {
        stringParam('VCS', 'svn')
        stringParam('BRANCH', 'trunk')
    }

    wrappers {
        timestamps()
        preBuildCleanup()
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')
    }

    logRotator(-1, 10, -1, 1)

    jdk('(System)')

    concurrentBuild(false)

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
        shell('cd arcadia && ./ya make --checkout mail/java/wmi')

        maven {
            goals('clean install deploy -P production,aqua-report,aqua-report-archive')
            providedGlobalSettings('global-yandex-settings-xml')
            mavenInstallation('mvn')
            rootPOM('arcadia/mail/java/wmi/pom.xml')
        }

        maven {
            goals('deploy -P production,aqua-report,aqua-report-archive')
            providedGlobalSettings('global-yandex-settings-xml')
            mavenInstallation('mvn')
            rootPOM('arcadia/mail/java/wmi/wmi-settings-tests/pom.xml')
        }
    }
}
