freeStyleJob('build-arcadia-packages') {
    description('''
Собирает релиз akita, sendbernar, hound, mops
<br/>
Эта джоба сгенерирована автоматически. <br/>
<img src="https://common.jenkins.mail.yandex.net/job/build-arcadia-packages/buildTimeGraph/png" />
<br/>
    ''')

    logRotator(30, 200, 30, 200)
    concurrentBuild()

    parameters {
        stringParam('VCS', 'svn')
        stringParam('BRANCH', 'trunk')
        stringParam('PROJECTS', '')
        stringParam('PACKAGE_VERSION', '')
        labelParam('LABEL') {
            defaultValue('maildev')
        }
        booleanParam('RUN_ARCADIA_TEST', false, 'Запускать ли тесты из аркадии')
        booleanParam('STRIP_BINARIES', false, 'Отделить отладочные символы')
    }

    wrappers {
        timestamps()

        buildName('${ENV,var="BRANCH"} at ${LABEL}')
        colorizeOutput('xterm')
        sshAgent('robot-gerrit-ssh-key')

        preBuildCleanup {
            includePattern('asg/**')
            includePattern('arcadia/**')
            deleteDirectories(true)
        }
    }

    steps {
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/clone_arcadia.sh'))
        shell(readFileFromWorkspace('arcadia/mail/jenkins_groovy/yamail-wmi-jobs/build_arcadia_packages.sh'))

        environmentVariables {
            propertiesFile('package_version.properties')
        }

        buildDescription('', '$PACKAGE_VERSION')
    }
}

multiJob('build-default') {
    displayName('Ночная сборка default')
    description("""Эта джоба сгенерирована автоматически.
            <br/>
            <h1>Прогреваем кеши сборки</h1>
            <h2>Время прогона</h2>
            <br/>
            <img src="https://common.jenkins.mail.yandex.net/job/build-default/buildTimeGraph/png" />""")

    label('maildev')

    logRotator(30, 200, 30, 200)

    parameters {
        stringParam('VCS', 'svn')
        stringParam('BRANCH', 'trunk')
        stringParam('PROJECTS', 'akita hound sendbernar mops')
    }

    triggers {
        cron('0 2 * * *')
    }

    wrappers {
        timestamps()
        preBuildCleanup()
        buildName('$BRANCH')
        colorizeOutput('xterm')
    }

    steps {
        phase('BUILD WEBMAIL') {
            for(i = 1; i <= 6; i++) {
                phaseJob('build-arcadia-packages') {
                    killPhaseCondition('NEVER')
                    parameters {
                        currentBuild()
                        nodeLabel('LABEL', 'maildev'+i+'.vla.yp-c.yandex.net')
                    }
                }
            }
        }
    }

    publishers {
        mailer('webmail-team@yandex-team.ru')
    }
}
